// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Label.cc,v 1.2 1999/03/09 20:55:09 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_Label.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_Statement.hh"

IIRScram_Label::~IIRScram_Label(){}

void 
IIRScram_Label::_publish_vhdl(ostream &_vhdl_out) {
  get_declarator()->_publish_vhdl(_vhdl_out);
}

void 
IIRScram_Label::_publish_cc_elaborate() {
  _get_declarator()->_publish_cc();
}


void 
IIRScram_Label::_publish_cc() {
  _get_declarator()->_publish_cc();
}

IIRScram_Declaration::declaration_type 
IIRScram_Label::_get_type(){
  return LABEL;
}

set<IIR_Declaration> *
IIRScram_Label::_find_declarations( IIR_Name *name ){
  ASSERT( get_statement() != NULL );

  return get_statement()->_find_declarations( name );
}

void 
IIRScram_Label::_make_interface_visible( symbol_table *sym_tab ){
  ASSERT( get_statement() != NULL );
  ASSERT( sym_tab != NULL );

  get_statement()->_make_interface_visible( sym_tab );
}

IIR_List *
IIRScram_Label::_get_statement_list(){
  ASSERT( get_statement() != NULL );
  return get_statement()->_get_statement_list();
}


IIR*
IIRScram_Label::_clone() {
  IIR_Label *clone = new IIR_Label();

  IIRScram_Declaration::_clone(clone);

  clone->set_statement(get_statement());
  IIR_AttributeSpecification *attr = attributes.first();
  while (attr != NULL) {
    clone->attributes.append(attr);
    attr = attributes.successor(attr);
  }

  return clone;
}


IIR_Boolean
IIRScram_Label::_is_block_statement() {
  return get_statement()->_is_block_statement();
}

IIR_Boolean
IIRScram_Label::_is_concurrent_generate_statement() {
  return get_statement()->_is_concurrent_generate_statement();
}

void
IIRScram_Label::_publish_cc_binding_name(ostream& outstream) {
  get_statement()->_publish_cc_binding_name(outstream);
}

