#ifndef IIRSCRAM_INTEGER_TYPE_DEFINITION_HH
#define IIRSCRAM_INTEGER_TYPE_DEFINITION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_IntegerTypeDefinition.hh,v 1.3 1999/08/02 12:50:06 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_IntegerTypeDefinition.hh"

class IIRScram_IntegerTypeDefinition : public IIRBase_IntegerTypeDefinition {

public:
  IIR_Boolean _is_discrete_type(){ return true; }
  IIR_Boolean _is_numeric_type(){ return true; }
  IIR_Boolean _is_integer_type(){ return true; }
  IIR_Boolean _is_iir_integer_type_definition(){ return true; }

  //void _publish_vhdl_decl(ostream &);

  void _publish_cc_decl_cc();
  void _publish_cc_left();
  void _publish_cc_right();
  void _publish_cc_universal_type();
  void _publish_cc_kernel_type();
  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();
  void _publish_cc_type_string();

  virtual void _publish_cc_data_members();

  //The following function publishes the function for the
  // `IMAGE attribute for integer Type definition
  virtual void _publish_cc_attribute_image();

  //The following function publishes the function for the
  // `VALUE attribute for integer Type definition
  virtual void _publish_cc_attribute_value();

  IIR_TypeDefinition *_check_special_compatible( IIR_TypeDefinition * );

  IIR_TypeDefinition *_get_new_subtype();

protected:
  IIRScram_IntegerTypeDefinition() {}
  virtual ~IIRScram_IntegerTypeDefinition() = 0;

  void _build_implicit_operators( set<IIR_Declaration> * );
    
private:
};
#endif
