#ifndef IIRSCRAM_FUNCTION_DECLARATION_HH
#define IIRSCRAM_FUNCTION_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_FunctionDeclaration.hh,v 1.3 1999/10/07 14:05:04 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_FunctionDeclaration.hh"

template <class type> class set;
class ostream;

class IIRScram_FunctionDeclaration : public IIRBase_FunctionDeclaration {
public:
  void _publish_vhdl_decl(ostream &);

  void _publish_cc();
  void _publish_cc_decl();
  void _publish_cc_resolution_function();
  void _publish_cc_resolution_function_name();
  void _publish_cc_type_conversion_function();
  void _publish_cc_type_conversion_function_name();
  void _publish_cc_wait_data();
  void _publish_cc_init_function();
  void _publish_cc_state_object_init();
  void _publish_cc_bounds();
  void _publish_cc_necessary_copying();
  void _publish_cc_read_or_write(const char *, const char *);
  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();
  
  IIR_Boolean _is_possible_resolution_function();
  IIR_Boolean _is_possible_type_conversion_function();
  IIR_TypeDefinition* _get_return_type();

  declaration_type _get_type();
  IIR_TypeDefinition *_get_subtype();

  // We can have array valued functions.
  IIR_TypeDefinition *_get_type_of_element( int );
  IIR_Int32 _get_num_indexes();

  void _mangle_declarator();
  
  IIR_Boolean _is_operator();
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return FALSE; }
  set<IIR_Declaration> *_find_declarations( IIR_Name * ){ return NULL;  }
  IIR *_clone();

  IIR_Boolean _is_iir_function_declaration(){ return TRUE; }
  IIR_Boolean _is_access_type();

  // This method looks at the function declaration and determines if it
  // could be a conversion function based on the rules in 4.3.2.1 of the
  // '93 LRM.
  IIR_Boolean _could_be_conversion_function( );

protected:
  IIRScram_FunctionDeclaration() {}
  virtual ~IIRScram_FunctionDeclaration() = 0;
    
private:
};
#endif

