#ifndef IIRSCRAM_ENUMERATION_LITERAL_HH
#define IIRSCRAM_ENUMERATION_LITERAL_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_EnumerationLiteral.hh,v 1.2 1999/03/09 20:54:18 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_EnumerationLiteral.hh"
#include "IIR_Declaration.hh"

class IIR_Declaration;
template <class type> class set;
class ostream;
class IIR_List;

class IIRScram_EnumerationLiteral : public IIRBase_EnumerationLiteral {

public:
  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);
  void _publish_cc();
  void _publish_cc_universal_value();
  void _publish_cc_state_object_init();
  void _publish_cc_headers();
  void _publish_cc_value();

  void _publish_cc_initialization_value();

  //While publishing the if and case statements, the enumeration literals
  //must be converted to type of the enumeration literal
  void _publish_cc_condition();

  IIRScram_Declaration::declaration_type _get_type();
  IIR_TypeDefinition *_get_subtype();
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  set<IIR_Declaration> *_symbol_lookup();
  IIR *_rval_to_decl( IIR_TypeDefinition * );
  void _type_check( set<IIR_TypeDefinition> * );
  IIR *_clone();

  ostream &_print( ostream & );

  void _publish_cc_bounds();
  void _publish_cc_direction();
  void _publish_cc_data();
  void _publish_cc_wait_data();

  IIR_Boolean _is_enumeration_literal() { return TRUE; }
  IIR_Boolean _is_character_literal();
  IIR_Boolean _is_iir_enumeration_literal(){ return TRUE; }
  IIR_Boolean _is_static_expression() { return TRUE;}
  IIR_Boolean _is_overloadable(){ return TRUE; }
  IIR_Boolean _is_ascending_range();
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return FALSE; }
  IIR_Boolean _is_resolved();
  IIR_Boolean _is_homograph_of( IIR_Declaration * );

  // an empty function to prevent incorrect error message.
  void _add_declarations_in_initializations() {};
  void _add_decl_into_cgen_symbol_table() {};

  IIR_AttributeSpecificationList* _get_attribute_specification_list(){ return &attributes; }

protected:
  IIRScram_EnumerationLiteral() {}
  virtual ~IIRScram_EnumerationLiteral() = 0;
    
private:
};
#endif
