// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Elsif.cc,v 1.2 1999/03/09 20:54:11 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_Elsif.hh"
#include "IIR_SequentialStatement.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "StandardPackage.hh"
#include "IIR_EnumerationTypeDefinition.hh"

IIRScram_Elsif::~IIRScram_Elsif() {}


void 
IIRScram_Elsif::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_condition()->_is_resolved() == TRUE);

  _vhdl_out << "elsif ";
  get_condition()->_publish_vhdl(_vhdl_out);
    
  _vhdl_out << " then\n";
    
  if (then_sequence_of_statements.num_elements() != 0) {
    then_sequence_of_statements._publish_vhdl(_vhdl_out);
  }
    
  if (get_else_clause() != NULL) {
    get_else_clause()->_publish_vhdl(_vhdl_out);
  }
}


void 
IIRScram_Elsif::_publish_cc() {
  ASSERT(get_condition()->_is_resolved() == TRUE);

  _cc_out << "else if (SAVANT_BOOLEAN_TRUE ==";
  get_condition()->_publish_cc();
  _cc_out << ") {\n  ";
    
  if (then_sequence_of_statements.num_elements() != 0) {
    then_sequence_of_statements._publish_cc();
  }
  _cc_out << "}\n";
    
  if (get_else_clause() != NULL) {
    get_else_clause()->_publish_cc();
  }
}


void
IIRScram_Elsif::_publish_cc_decl_for_loop_iterator() {
  then_sequence_of_statements._publish_cc_decl_for_loop_iterator();
  if (get_else_clause() != NULL) {
    get_else_clause()->_publish_cc_decl_for_loop_iterator();
  }
}

void
IIRScram_Elsif::_build_wait_list(dl_list<IIRScram_WaitStatement>* list) {
  then_sequence_of_statements._build_wait_list(list);
  if (get_else_clause() != NULL) {
    get_else_clause()->_build_wait_list(list);
  }  
}

void 
IIRScram_Elsif::_build_procedure_call_stmt_list(dl_list<IIR_ProcedureCallStatement> *list) {
  then_sequence_of_statements._build_procedure_call_stmt_list(list);
  if (get_else_clause() != NULL) {
    get_else_clause()->_build_procedure_call_stmt_list(list);
  }
}

void
IIRScram_Elsif::_get_list_of_input_signals(set<IIR_Declaration>* list) {
  if(get_condition() != NULL) {
    get_condition()->_get_list_of_input_signals(list);
  }
  if(get_else_clause() != NULL) {
    get_else_clause()->_get_list_of_input_signals(list);
  }
  then_sequence_of_statements._get_list_of_input_signals(list);
}

void
IIRScram_Elsif::_get_signal_source_info(set<IIR_Declaration>* siginfo) {
  if(get_else_clause() != NULL) {
    get_else_clause()->_get_signal_source_info(siginfo);
  }
  then_sequence_of_statements._get_signal_source_info(siginfo);
}

void 
IIRScram_Elsif::_type_check( set<IIR_TypeDefinition> *conext_set ){
  set_condition( IIR_Statement::_type_check_and_resolve_boolean_condition( get_condition() ) );
 
  if( get_else_clause() != NULL ){
    set<IIR_TypeDefinition> *bool_rvals = new set<IIR_TypeDefinition>(StandardPackage::boolean_type);
    get_else_clause()->_type_check( bool_rvals );
    delete bool_rvals;
  }
}

IIR_Boolean 
IIRScram_Elsif::_type_check_return_statements( set<IIR_TypeDefinition> *context_set, IIR_SubprogramDeclaration *subprogram_decl ){
  IIR_Boolean retval = FALSE;

  IIR_Boolean retval1 = FALSE;
  retval1 = 
    IIR_SequentialStatement::_type_check_return_statements(context_set, &then_sequence_of_statements, subprogram_decl );

  IIR_Boolean retval2 = FALSE;
  if( get_else_clause() != NULL ){
    retval2 =
      get_else_clause()->_type_check_return_statements( context_set, subprogram_decl );
  }

  if( retval1 == TRUE || retval2 == true ){
    retval = TRUE;
  }

  return retval;
}


IIR*
IIRScram_Elsif::_clone() {
  IIR *condition;
  IIR_Elsif *elsif;
  IIR_SequentialStatement *stmt, *newstmt;
  IIR_Elsif *clone = new IIR_Elsif();
  IIRScram::_clone( clone );

  condition = get_condition()->_clone();
  clone->set_condition(condition);
  elsif = get_else_clause();
  if (elsif != NULL) {
    elsif = (IIR_Elsif*)elsif->_clone();
  }
  clone->set_else_clause(elsif);

  stmt = then_sequence_of_statements.first();
  while (stmt != NULL) {
    newstmt = (IIR_SequentialStatement*)stmt->_clone();
    clone->then_sequence_of_statements.append(newstmt);
    stmt = then_sequence_of_statements.successor(stmt);
  }

  return clone;
}
