#ifndef IIRSCRAM_CONFIGURATION_DECLARATION_HH
#define IIRSCRAM_CONFIGURATION_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConfigurationDeclaration.hh,v 1.2 1999/03/09 20:53:44 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ConfigurationDeclaration.hh"

class IIR_ArchitectureDeclaration;

class IIRScram_ConfigurationDeclaration : public IIRBase_ConfigurationDeclaration {
public:
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_binding_name(ostream &);
  void _publish_vhdl_with_library_name(ostream &);
  void _publish_cc_elaborate();

  void _publish_cc_headerfile();
  void _publish_cc_headers();
  void _publish_cc_class_includes();
  void _publish_cc_class();
  void _publish_cc_object_pointers();

  void _publish_cc_ccfile();
  void _publish_cc_headerfiles_for_cc(){}
  void _publish_cc_constructor();
  void _publish_cc_constructor_with_no_arguments();
  void _publish_cc_constructor_with_arguments();
  void _publish_cc_object_pointers_init();

  void _publish_cc_destructor();
  void _publish_cc_instantiate();
  void _publish_cc_createNetInfo();
  void _publish_cc_connect();
  void _publish_cc_getboundentityinfo();

  void _publish_cc(); // Duymmy function
  
  void _publish_cc_binding_name( ostream& = _cc_out );

  declaration_type _get_type();

  IIR_Boolean _is_iir_configuration_declaration(){ return TRUE; }
  IIR_Boolean _is_primary_unit(){ return TRUE; }
  IIR_Boolean _is_configuration_decl() { return TRUE; }
  
  IIR_ArchitectureDeclaration *_get_configured_architecture();

  void _make_interface_visible( symbol_table * );

  void _type_check();

protected:
  IIRScram_ConfigurationDeclaration() {}
  virtual ~IIRScram_ConfigurationDeclaration() = 0;
    
private:
};
#endif
