// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConcurrentGenerateForStatement.cc,v 1.5 1999/09/30 03:05:29 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_ConcurrentGenerateForStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_Label.hh"
#include "IIR_List.hh"
#include "IIR_ConcurrentStatementList.hh"
#include "IIR_DeclarationList.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_ComponentDeclaration.hh"
#include "IIR_ComponentInstantiationStatement.hh"
#include "IIR_BlockStatement.hh"
#include "IIR_ProcessStatement.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_AliasDeclaration.hh"
#include "IIR_ConfigurationSpecification.hh"
#include "IIR_Designator.hh"
#include "IIR_LibraryUnit.hh"
#include "IIR_EntityDeclaration.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "symbol_table.hh"
#include "set.hh"

IIRScram_ConcurrentGenerateForStatement::~IIRScram_ConcurrentGenerateForStatement(){}

void 
IIRScram_ConcurrentGenerateForStatement::_publish_vhdl(ostream &_vhdl_out) {
  if(get_label() != NULL) {
    get_label()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ":\n";
  }

  _vhdl_out << " for ";
   get_generate_parameter_specification()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " in ";
  get_generate_parameter_specification()->get_subtype()->_publish_vhdl_range(_vhdl_out);
  _vhdl_out << " generate\n";

  if(block_declarative_part.num_elements() != 0) {
    block_declarative_part._publish_vhdl_decl(_vhdl_out);
  }

  _vhdl_out << "   begin\n";

  concurrent_statement_part._publish_vhdl(_vhdl_out);

  _vhdl_out << "   end generate ";
  if(get_label() != NULL) {
    get_label()->_publish_vhdl(_vhdl_out);
  }
  _vhdl_out << ";\n";

}

void 
IIRScram_ConcurrentGenerateForStatement::_type_check(){
  block_declarative_part._type_check_attribute_specifications( concurrent_statement_part );
  ASSERT( get_generate_parameter_specification() != NULL );  
  get_generate_parameter_specification()->set_subtype( _type_check_iteration_scheme( get_generate_parameter_specification() ) );
}

void 
IIRScram_ConcurrentGenerateForStatement::_type_check_instantiate_statements(){
  // Put our declarations back into scope.
  ASSERT( get_generate_parameter_specification() != NULL );
  _get_symbol_table()->open_scope( this );
  _get_symbol_table()->make_visible( get_generate_parameter_specification() );
  concurrent_statement_part._type_check_instantiate_statements();
  _get_symbol_table()->close_scope( this );
}

// void 
// IIRScram_ConcurrentGenerateForStatement::_reopen_scope( symbol_table *sym_tab ){
//   sym_tab->reopen_scope( this );
// }

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_generate_elaborate()
{
  IIR_ConcurrentStatement *conc_stmt;
  char *temp = _current_architecture_name;
  char *old_current_name = _current_publish_name;

  ostrstream newName;

  _current_publish_name = "SG";

  conc_stmt =  concurrent_statement_part.first();

  while (conc_stmt != NULL) {
    // Need to check if generate statements can have other concurrent
    // statements that will need elaboration. If so that check should
    // be added to the following if condition.

    switch (conc_stmt->get_kind()) {
    case IIR_CONCURRENT_GENERATE_FOR_STATEMENT:
    case IIR_BLOCK_STATEMENT:
    case IIR_CONCURRENT_GENERATE_IF_STATEMENT:
      conc_stmt->_publish_cc_elaborate();
      break;

    case IIR_PROCESS_STATEMENT:
    case IIR_COMPONENT_INSTANTIATION_STATEMENT:
      // Prevent the error message from popping up.
      break;
      
    default:
      cerr << "ERROR! IIRScram_ConcurrentGenerateForStatement::"
	   << "_publish_cc_generate_elaborate(): unknown conc_statement "
	   << "type |" << conc_stmt->get_kind_text() << "|" << endl;
      break;
    }
    conc_stmt = concurrent_statement_part.successor(conc_stmt);
  }

  _current_architecture_name = temp;
  _current_publish_name      = old_current_name;
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_init(IIR *scope)
{
  get_generate_parameter_specification()->_publish_cc();
  _cc_out << " = ";
  get_generate_parameter_specification()->_publish_cc_type_name();
  _cc_out << "(ObjectBase::VARIABLE, proc->";
  _publish_cc_scoping_prefix(scope, this, _cc_out);
  _cc_out << "getGenerateConstant(1));\n";
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_universal_generate_range()
{
  _cc_out << "(";
  
  if (get_generate_parameter_specification()->get_subtype()->_is_ascending_range()) {
    ((IIR_ScalarTypeDefinition *) get_generate_parameter_specification()->get_subtype())->get_right()->_publish_cc_value();
    _cc_out << " - ";
    ((IIR_ScalarTypeDefinition *) get_generate_parameter_specification()->get_subtype())->get_left()->_publish_cc_value();
    _cc_out << " + 1";
  }
  else {
    ((IIR_ScalarTypeDefinition *) get_generate_parameter_specification()->get_subtype())->get_left()->_publish_cc_value();
    _cc_out << " - ";
    ((IIR_ScalarTypeDefinition *) get_generate_parameter_specification()->get_subtype())->get_right()->_publish_cc_value();
    _cc_out << " + 1";
  }
  
  _cc_out << ")";
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_assign_to_loop_constant(const char *localIterator)
{
  _cc_out << "  assignVariable(";
  get_generate_parameter_specification()->_publish_cc();
  _cc_out << ", ";
  get_generate_parameter_specification()->get_subtype()->_publish_cc_kernel_type();
  _cc_out << "(ObjectBase::VARIABLE, " << localIterator
	  << "), nullInfo, nullInfo);\n";
}

IIR_DeclarationList*
IIRScram_ConcurrentGenerateForStatement::_get_declaration_list() {
  return &block_declarative_part;
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_generate_for_loop()
{
  IIR_ScalarTypeDefinition *range;

  ASSERT ( get_generate_parameter_specification()->get_subtype()->_is_iir_scalar_type_definition() == TRUE );
  range = (IIR_ScalarTypeDefinition *) get_generate_parameter_specification()->get_subtype();
  
  _cc_out << "  for(i = ";
  range->get_left()->_publish_cc_value();
  _cc_out << "; (i ";

  if (range->_is_ascending_range() == TRUE) {
    _cc_out << " <= ";
  }
  else {
    _cc_out << " >= ";
  }

  range->get_right()->_publish_cc_value();
  _cc_out << "); ";

  if (range->_is_ascending_range() == TRUE) {
    _cc_out << "i++";
  }
  else {
    _cc_out << "i--";
  }

  _cc_out << ")  ";
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc() {
  ostrstream ent_arch_generate_for;
  IIR_Char* generate_for_unit_name;
  IIR *temp                   = _current_publish_node;
  char *old_architecture_name = _current_architecture_name;
  char *old_current_name      = _current_publish_name;
  ostrstream arch_name;
  PublishedUnit saved_publishing_unit = _get_currently_publishing_unit();
  _set_currently_publishing_unit(GENERATE_FOR);
  _current_publish_node = this;
  
  ent_arch_generate_for << _current_entity_name
			<< "_" << _current_architecture_name;
  _publish_cc_enclosing_stmt_to_architecture_path(ent_arch_generate_for);
  _get_label()->_get_declarator()->_print(ent_arch_generate_for);
  ent_arch_generate_for << ends;
  
  generate_for_unit_name = ent_arch_generate_for.str();

  _cc_out.set_file(TRUE, generate_for_unit_name, "_waits.hh");
  _cc_out << "#ifndef " << generate_for_unit_name << "_WAITS_HH\n";
  _cc_out << "#define " << generate_for_unit_name << "_WAITS_HH\n" << endl;
  _cc_out << "class BasicState;\n\n";

  _cc_out.set_file(TRUE, generate_for_unit_name, "_waits.cc");

  _current_publish_name = "SG";
  concurrent_statement_part._publish_cc();

  _current_publish_name      = old_current_name;
  _current_architecture_name = old_architecture_name;
  
  _cc_out.set_file(TRUE, generate_for_unit_name, "_waits.hh");
  _cc_out << "#endif\n";
  
  _publish_cc_declarations();
  
  _current_publish_node = temp;

  _set_currently_publishing_unit(saved_publishing_unit);

  delete [] ent_arch_generate_for.str();
  delete [] arch_name.str();
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_declarations() {
  IIR_Char *generate_unit_name;
  ostrstream ent_arch_generate;

  ent_arch_generate << _current_entity_name << "_"
		    << _current_architecture_name ;
  _publish_cc_enclosing_stmt_to_architecture_path(ent_arch_generate);
  ent_arch_generate << "_"
		    << *_get_label() << ends;

  generate_unit_name = ent_arch_generate.str();

  _cc_out.set_file(TRUE, generate_unit_name, "_decls.hh");
  _cc_out << "#ifndef " << generate_unit_name << "_DECLS_HH" << endl;
  _cc_out << "#define " << generate_unit_name << "_DECLS_HH\n" << endl;
  
  _cc_out << "#include\"";
  _cc_out << _current_entity_name << "_" << _current_architecture_name;
  _publish_cc_enclosing_stmt_to_architecture_path();
  _cc_out  << "_decls.hh\"\n\n";
  
  block_declarative_part._publish_cc();
  
  _cc_out.set_file(TRUE, generate_unit_name, "_decls.hh");

  _cc_out << " extern ";
  get_generate_parameter_specification()->_publish_cc_type_name();
  _cc_out << " ";
  get_generate_parameter_specification()->_publish_cc();
  _cc_out << ";\n";
  
  _cc_out << "#endif\n";
  
  _cc_out.set_file(TRUE, generate_unit_name, "_decls.cc");
  _cc_out << "#include \"" << generate_unit_name << "_decls.hh\"\n\n";
  
  block_declarative_part._publish_cc_decl();

  // Publish definition for the generate constant guy
  
  get_generate_parameter_specification()->_publish_cc_type_name();
  _cc_out << " ";
  get_generate_parameter_specification()->_publish_cc();
  _cc_out << "(ObjectBase::VARIABLE);\n";
  
  delete [] generate_unit_name;
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_class() {
  _cc_out << "class ";
  this->_publish_cc_binding_name();
  _cc_out << "_elab : public _savant_entity_elab  {\n";
  _cc_out << "public:\n\n";

  this->_publish_cc_binding_name();
  _cc_out << "_elab(";

  _cc_out << _current_publish_name << _current_entity_name << "_"
	  << _current_architecture_name;
  _publish_cc_enclosing_stmt_to_architecture_path();
  _cc_out << "_elab*);\n";

  _cc_out << "~";
  this->_publish_cc_binding_name();
  _cc_out << "_elab();\n";

  _cc_out << _current_publish_name << _current_entity_name << "_"
	  << _current_architecture_name;
  _publish_cc_enclosing_stmt_to_architecture_path();
  _cc_out << "_elab* enclosingScope;\n";
  
  _cc_out << "void instantiate();\n";
  _cc_out << "void createNetInfo();\n";
  _cc_out << "void connect(int, int, ...);\n";
  _cc_out << "int getGenerateConstant(int);\n";
  _cc_out << "void resetGenerateConstant();\n";

  _publish_cc_signals(&block_declarative_part);
  _publish_cc_object_pointers(&concurrent_statement_part);
  
  _cc_out << "static int generateConstant;\n";
  _cc_out << "static ArrayDirn_t generateDirection;\n";
  
  _cc_out << "};\n\n";
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_headerfile() {
  ostrstream filename;

  filename << "SG" << _current_entity_name << "_"
	   << _current_architecture_name;
  _publish_cc_enclosing_stmt_to_architecture_path(filename);
  filename << "_" << *(_get_label()) << ends;

  _cc_out.set_file(TRUE, filename.str(), "_elab.hh");
  _cc_out << "#ifndef " << filename.str() << "_HH\n";
  _cc_out << "#define " << filename.str() << "_HH\n\n";


  _cc_out << "#include \"";
  _cc_out << _current_publish_name;
  _cc_out << _current_entity_name << "_"
	  << _current_architecture_name;
  _publish_cc_enclosing_stmt_to_architecture_path();
  _cc_out << "_elab.hh\"\n";

  _cc_out << "#include \"_savant_entity_elab.hh\"\n";

  // Include the current declarative region 
  _cc_out << "#include \"";
  _cc_out << _current_entity_name << "_"
	  << _current_architecture_name;
  _publish_cc_enclosing_stmt_to_architecture_path();
  _cc_out << "_" << *_get_label() << "_decls.hh\"\n";

  //  _publish_cc_headers();
  _cc_out << "\n";
  _publish_cc_class_includes(&concurrent_statement_part);
  _cc_out << "\n";
  _publish_cc_class();
  
  _cc_out << "\n#endif" << endl;

  delete [] filename.str();
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_elaborate() {
  PublishedUnit saved_publishing_unit = _get_currently_publishing_unit();
  _set_currently_publishing_unit(GENERATE_FOR);
  _publish_cc_headerfile();
  _publish_cc_ccfile();
  _publish_cc_generate_elaborate();
  _set_currently_publishing_unit(saved_publishing_unit);
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_ccfile() {
  ostrstream filename;
  
  filename << "SG" << _current_entity_name << "_"
	   << _current_architecture_name;
  _publish_cc_enclosing_stmt_to_architecture_path(filename);
  filename << "_"
	   << *_get_label() << ends;

  IIR_Char* filename_ptr = filename.str();

  _cc_out.set_file(TRUE, filename_ptr, "_elab.cc");
  _cc_out << "#include \"" << filename_ptr << "_elab.hh\"\n\n";

  _cc_out << "#ifdef SEQUENTIAL" << endl;
  _cc_out << "#include \"BaseSequential.hh\" " << endl;
  _cc_out << "#define OBJTYPE BaseSequential" << endl;
  _cc_out << "#else" << endl;
  _cc_out << "#include \"BasicTimeWarp.hh\" " << endl;
  _cc_out << "#define OBJTYPE BasicTimeWarp" << endl;
  _cc_out << "#endif\n" << endl;
  
  _publish_cc_headerfiles_for_cc();
  _cc_out << "extern OBJTYPE *proc_array[];\n";

  _publish_cc_static_members();
  _publish_cc_constructor();
  _publish_cc_destructor(&concurrent_statement_part);
  _publish_cc_instantiate();
  _publish_cc_createNetInfo();
  _publish_cc_connect();
  _publish_cc_getGenerateConstant();
  _publish_cc_resetGenerateConstant();

  delete [] filename_ptr;
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_static_members()
{
  _cc_out << "int\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::generateConstant = 0;\n" << endl;

  _cc_out << "ArrayDirn_t\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::generateDirection = ";
  if (get_generate_parameter_specification()->_is_ascending_range()) {
    _cc_out << "to";
  }
  else {
    _cc_out << "downto";
  }

  _cc_out << ";\n" << endl;
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_getGenerateConstant()
{
  _cc_out << "int\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::getGenerateConstant(int flag)  {\n";
  _cc_out << "  int returnValue = generateConstant;\n\n";
  _cc_out << "  if (flag)  {\n";
  _cc_out << "    generateConstant += ((generateDirection == to) ? 1 : -1);\n";
  _cc_out << "   }\n\n  return returnValue;\n}\n\n";
}
  
void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_resetGenerateConstant()
{
  _cc_out << "void ";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::resetGenerateConstant()  {\n";
  _cc_out << "  generateConstant = ";
  ((IIR_ScalarTypeDefinition *) get_generate_parameter_specification()->get_subtype())->get_left()->_publish_cc_value();
  _cc_out << ";\n}\n\n";
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_headerfiles_for_cc() {
  _publish_cc_headerfiles_for_cc_generate_statement();
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_constructor() {
  _publish_cc_constructor_with_no_arguments();
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_constructor_with_no_arguments()
{
  this->_publish_cc_binding_name();
  _cc_out << "_elab::";

  this->_publish_cc_binding_name();
  _cc_out << "_elab(";
  
  _cc_out << _current_publish_name << _current_entity_name << "_"
	  << _current_architecture_name;
  _publish_cc_enclosing_stmt_to_architecture_path();
  _cc_out << "_elab* outerScope)  {\n";
  _cc_out << "  generateConstant = ";
  ((IIR_ScalarTypeDefinition *) get_generate_parameter_specification()->get_subtype())->get_left()->_publish_cc_value();
  _cc_out << ";\n";
  _cc_out << "  enclosingScope = outerScope;\n";
  
  _publish_cc_object_pointers_init();
  _cc_out << "}\n";
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_signal_objects_init(int flag) {
  IIR_Declaration *decl;
  int first = 0;
  decl = block_declarative_part.first();

  while (decl != NULL) {
    if (decl->get_kind() == IIR_SIGNAL_DECLARATION) {
      if ((first == 0) && (flag == 1)) {
	_cc_out << ":\n";
	first = 1;
      }
      else {
	_cc_out << ",\n";
      }
      
      decl->_publish_cc_elaborate();
      _cc_out << "(ObjectBase::SIGNAL_NETINFO";

      if (((IIR_SignalDeclaration *) decl)->get_subtype()->_is_array_type()) {
	_cc_out << ", ";
	((IIR_SignalDeclaration *) decl)->get_subtype()->_publish_cc_range();
      }
      _cc_out <<  ")";

      if( decl->_get_implicit_declarations() != NULL
	  && decl->_get_implicit_declarations()->num_elements() != 0 ) {
	IIR_Declaration* imp_decl = decl->_get_implicit_declarations()->get_element();
	while (imp_decl != NULL) {
	  if (imp_decl->get_kind() == IIR_SIGNAL_DECLARATION) {
	    _cc_out << ",\n";
	    imp_decl->_publish_cc_elaborate();
	    _cc_out << "(ObjectBase::SIGNAL_NETINFO";

	    if (((IIR_SignalDeclaration *) imp_decl)->get_subtype()->_is_array_type()) {
	      _cc_out << ", ";
	      ((IIR_SignalDeclaration *)imp_decl)->get_subtype()->_publish_cc_range();
	    }
	    _cc_out << ")";
	  }
	  imp_decl = decl->_get_implicit_declarations()->get_next_element();
	}
      }
    }
    else if (decl->get_kind() == IIR_ALIAS_DECLARATION) {
      if (((IIR_AliasDeclaration *) decl)->get_name()->_is_signal()) {
	if ((first == 0) && (flag == 1)) {
	  _cc_out << ":\n";
	  first = 1;
	}
	else {
	  _cc_out << ",\n";
	}
	((IIR_AliasDeclaration *) decl)->_publish_cc_elaborate_alias_init();
      }
    }
    
    decl = block_declarative_part.successor(decl);
  }
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_object_pointers_init()
{
  char *temp = _current_architecture_name;
  char *old_current_name = _current_publish_name;

  IIR_ConcurrentStatement *conc_stmt;
  IIR_Boolean found = FALSE;
  int wanted_instantiation = 1;
  IIR_ConfigurationSpecification *config_spec_decl = NULL;
  IIR* tmpNode;


  conc_stmt = concurrent_statement_part.first();

  while (conc_stmt != NULL) {
    switch(conc_stmt->get_kind()) {
    case IIR_PROCESS_STATEMENT:
      if (conc_stmt->_get_label() != NULL) {
	_cc_out << *(conc_stmt->_get_label());
      }
      else {
	_cc_out << "ANON_PROCESS" << conc_stmt;
      }
      _cc_out << "_elab_obj = NULL;\n";
      break;

    case IIR_COMPONENT_INSTANTIATION_STATEMENT:
      IIR_ComponentDeclaration *componentName;
      componentName = (IIR_ComponentDeclaration *) conc_stmt->get_instantiated_unit();
      ASSERT(componentName->get_kind() == IIR_COMPONENT_DECLARATION);

      _cc_out << *(conc_stmt->_get_label())
	      << "_elab_obj = new ";
      componentName->_publish_cc_binding_name();
      _cc_out << "_elab[";
      _publish_cc_universal_generate_range();
      _cc_out << "](";
      
      conc_stmt->_get_generic_map_aspect()->_publish_cc();
      _cc_out << ");\n";

      _cc_out << "for(int i = 0; (i < ";
      _publish_cc_universal_generate_range();
      _cc_out << "); i++)  {\n";

      tmpNode = _current_publish_node;
      _current_publish_node = this;     
      conc_stmt->_publish_cc_concurrent_stmt_init(&block_declarative_part);
      _current_publish_node = tmpNode;
      _cc_out << "}\n";
      
      break;

    case IIR_BLOCK_STATEMENT:
      {
      _current_publish_name      = "SG";

      conc_stmt->_get_label()->_publish_cc_elaborate();
      _cc_out << "_elab_obj = new ";
      conc_stmt->_publish_cc_binding_name();
      _cc_out << "_elab[";
      _publish_cc_universal_generate_range();
      _cc_out << "](this";
      
      if ( ((IIR_BlockStatement *) conc_stmt)->generic_map_aspect.num_elements() > 0) {
	_cc_out << ", \n";
	tmpNode = _current_publish_node;
	_current_publish_node = conc_stmt;
	((IIR_BlockStatement *) conc_stmt)->generic_map_aspect._publish_cc_generic_map_aspect_for_conc_stmts();
	_current_publish_node = tmpNode;
      }
      
      _cc_out << ");\n";
      
      _current_architecture_name = temp;
      _current_publish_name      = old_current_name;
      }
      break;
    case IIR_CONCURRENT_GENERATE_FOR_STATEMENT:
    case IIR_CONCURRENT_GENERATE_IF_STATEMENT:
      {
      _current_publish_name      = "SG";
      
      conc_stmt->_get_label()->_publish_cc_elaborate();
      _cc_out << "_elab_obj = new ";
      conc_stmt->_publish_cc_binding_name();
      _cc_out << "_elab[";
      _publish_cc_universal_generate_range();
      _cc_out << "](this);\n";

      _current_architecture_name = temp;
      _current_publish_name      = old_current_name;
      }
    break;

    default:
      cerr << "ERROR! IIRScram_ConcurrentGenerateForStatement::"
	   << "_publish_cc_object_pointers_init(): unknown conc_statement "
	   << "type |" << conc_stmt->get_kind_text() << "|" << endl;
      break;
    }

    found = FALSE;
    conc_stmt = concurrent_statement_part.successor(conc_stmt);
  }
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_instantiate()
{
  IIR_ConcurrentStatement *conc_stmt;
  
  _cc_out << "void\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::instantiate()  {\n";

  _cc_out << "  int generateLeft = ";
  ((IIR_ScalarTypeDefinition *) get_generate_parameter_specification()->get_subtype())->get_left()->_publish_cc_value();
  _cc_out << ";\n\n";
  _cc_out << "int i;\n";
  
  conc_stmt = concurrent_statement_part.first();
  while (conc_stmt != NULL) {
    if (conc_stmt->get_kind() == IIR_PROCESS_STATEMENT) {
      ostrstream objectname;
      if (conc_stmt->_get_label() != NULL) {
	objectname << *(conc_stmt->_get_label()) << ends;
      }
      else {
	objectname << "ANON_PROCESS" << conc_stmt << ends;
      }
      
      char *objname = objectname.str();
      _cc_out << objname << "_elab_obj = new " << objname;
      _cc_out << " *[";
      _publish_cc_universal_generate_range();
      _cc_out << "]";
      _cc_out << ";\n";
      
      _cc_out << "  for(i = 0; (i < ";
      _publish_cc_universal_generate_range();
      _cc_out << "); i++)  {\n";
      _cc_out << "    " << objname << "_elab_obj[i] = new ";
      _cc_out << objname << "(this);\n" ;
      _cc_out << "    proc_array[";
      _cc_out << objname << "_elab_obj[i]->id";
      _cc_out << "] = (OBJTYPE *) " << objname << "_elab_obj[i];\n";
      _cc_out << "}\n";
      
      _number_of_processes += 1;
      delete [] objname;
    }
    else if ((conc_stmt->get_kind() == IIR_COMPONENT_INSTANTIATION_STATEMENT)||
	     (conc_stmt->_is_concurrent_generate_statement() == TRUE) ||
	     (conc_stmt->_is_block_statement() == TRUE)) {
      _publish_cc_generate_for_loop();
      _cc_out << "{\n";
      _publish_cc_assign_to_loop_constant();
      (conc_stmt->_get_label())->_publish_cc_elaborate();
      _cc_out << "_elab_obj[i - generateLeft].instantiate();\n";
      _cc_out << "  }\n";
    }
    else {
      cerr << "ERROR! IIRScram_ConcurrentGenerateForStatement::"
	   << "_publish_cc_instantiate(): unknown conc_statement "
	   << "type |" << conc_stmt->get_kind_text() << "|" << endl;
    }
    conc_stmt = concurrent_statement_part.successor(conc_stmt);
  }
  _cc_out << "createNetInfo();\n";
  _cc_out << "}\n";
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_body_for_component_createNetInfo(IIR_ConcurrentStatement *conc_stmt)
{
  ostrstream labelname;
  ostrstream objectname;
  int wanted_instantiation = 1;
  IIR_Boolean found = false;
  IIR_EntityDeclaration* bindingEntity;
  int noofelements = 0;
  
  conc_stmt->_get_label()->_print(labelname);
  labelname << "_elab_obj[i]." << ends;
  _current_elab_name = labelname.str();
  IIR* componentName = conc_stmt->get_instantiated_unit();
      
  if(componentName->get_kind() == IIR_COMPONENT_DECLARATION) {
    IIR_Declaration* decl = block_declarative_part.first();
    while(decl != NULL) {
      if(decl->get_kind() == IIR_CONFIGURATION_SPECIFICATION) {
	IIR_TextLiteral* local_componentName = componentName->_get_declarator();
	IIR_TextLiteral* binding_componentName = ((IIR_ConfigurationSpecification*)decl)->get_component_name()->_get_declarator();
	if(IIR_TextLiteral::_cmp(local_componentName, 
				 binding_componentName) == 0) {
	  IIR_Designator* designator = decl->_get_instantiation_list()->first();
	  
	  while(designator != NULL) {
	    switch(designator->get_kind()) {
	    case IIR_DESIGNATOR_EXPLICIT:
	      wanted_instantiation = IIR_TextLiteral::_cmp(((IIR_Declaration *) designator->_get_name())->get_declarator(), conc_stmt->_get_label()->get_declarator());
	      if(wanted_instantiation == 0) {
		found = TRUE;
		if(((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements() == 0) {
		  _current_publish_node = componentName;
		  objectname << "(( ";
		  IIR_LibraryUnit* lib_unit =((IIR_ConfigurationSpecification*)decl)->get_entity_aspect(); 
		  if(lib_unit != NULL) {
		    lib_unit->_publish_cc_binding_name(objectname);
		    bindingEntity = lib_unit->_get_entity();
		  }
		  objectname << "_elab*) " << *(conc_stmt->_get_label());
		  objectname << "_elab_obj->boundedEntity)->" << ends;
		  _current_publish_name = objectname.str();
		  bindingEntity->port_clause._publish_cc_port_map_aspect();
		}
		else {
		  _current_publish_node = componentName;
		  objectname << "(( ";
		  IIR_LibraryUnit* lib_unit =((IIR_ConfigurationSpecification*)decl)->get_entity_aspect(); 
		  if(lib_unit != NULL) {
			lib_unit->_publish_cc_binding_name(objectname);
			bindingEntity = lib_unit->_get_entity();
		  }
		  objectname << "_elab*) " << *(conc_stmt->_get_label());
		  objectname << "_elab_obj->boundedEntity)->" << ends;
		  _current_publish_name = objectname.str();
		  noofelements = ((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements();
		  if(noofelements != 0) {
		    ((IIR_ConfigurationSpecification*)decl)->port_map_aspect._publish_cc_elaborate();
		  }
		  else {
		    IIR_LibraryUnit* binding_unit =((IIR_ConfigurationSpecification*)decl)->get_entity_aspect();
		    if(binding_unit!= NULL) {
		      binding_unit->_get_entity()->port_clause._publish_cc_port_map_aspect();
		    }
		  }
		}
	      }
	      break;
	    case IIR_DESIGNATOR_BY_ALL:
	    case IIR_DESIGNATOR_BY_OTHERS:
	      found = TRUE;
	      if(((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements() == 0) {
		_current_publish_node = componentName;
		objectname << "(( ";
		IIR_LibraryUnit* lib_unit =((IIR_ConfigurationSpecification*)decl)->get_entity_aspect(); 
		if(lib_unit != NULL) {
		  lib_unit->_publish_cc_binding_name(objectname);
		  bindingEntity = lib_unit->_get_entity();
		}
		objectname << "_elab*) " << *(conc_stmt->_get_label());
		objectname << "_elab_obj->boundedEntity)->" << ends;
		_current_publish_name = objectname.str();
		bindingEntity->port_clause._publish_cc_port_map_aspect();
	      }
	      else {
		_current_publish_node = componentName;
		objectname << "(( ";
		IIR_LibraryUnit* lib_unit =((IIR_ConfigurationSpecification*)decl)->get_entity_aspect();
		if(lib_unit != NULL) {
		  lib_unit->_publish_cc_binding_name(objectname);
		  bindingEntity = lib_unit->_get_entity();
		}
		objectname << "_elab*) " << *(conc_stmt->_get_label());
		objectname << "_elab_obj->boundedEntity)->" << ends;
		_current_publish_name = objectname.str();
		noofelements = ((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements();
		if(noofelements != 0) {
		  ((IIR_ConfigurationSpecification*)decl)->port_map_aspect._publish_cc_elaborate();
		}
		else {
		  IIR_LibraryUnit* binding_unit =((IIR_ConfigurationSpecification*)decl)->get_entity_aspect();
		  if(binding_unit!= NULL) {
		    binding_unit->_get_entity()->port_clause._publish_cc_port_map_aspect();
		  }
		}
	      }
	      break;
	    }
	    if(found == TRUE) {
	      designator = NULL;
	    }
	    else {
	      designator =((IIR_ConfigurationSpecification*)decl)-> instantiation_list.successor(designator);
	    }
	  }
	}
      }
      if(found == TRUE) {
	decl = NULL;
      }
      else {
	decl = block_declarative_part.successor(decl);
      }
    }
  }
  
  objectname << *(conc_stmt->_get_label()) << "_elab_obj" << ends;
  _current_elab_name = objectname.str();
  conc_stmt->_publish_createNetInfo();
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_createNetInfo()
{
  IIR_ConcurrentStatement *conc_stmt;
  IIR_Boolean found = false;
  int wanted_instantiation = 1;
  IIR_Char* tmp  = _current_elab_name;
  IIR_Char* tmp2 = _current_publish_name;
  IIR* tmpNode   = _current_publish_node;
  PublishedUnit old_publishing_unit = _get_currently_publishing_unit();

  _set_currently_publishing_unit(GENERATE_FOR);
  
  _cc_out << "void\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::createNetInfo() {\n";
  _cc_out << "  int generateLeft = ";
  ((IIR_ScalarTypeDefinition *) get_generate_parameter_specification()->get_subtype())->get_left()->_publish_cc_value();
  _cc_out << ";\n\n";
  _cc_out << "int i;\n";
  
  conc_stmt = concurrent_statement_part.first();
  while (conc_stmt != NULL) {
    ostrstream objectname;
    ostrstream labelname;
    _current_publish_name = NULL;
    _current_publish_node = this;
    
    if (conc_stmt->get_kind() == IIR_PROCESS_STATEMENT) {
      _publish_cc_generate_for_loop();
      _cc_out << "{\n";
      _publish_cc_assign_to_loop_constant();
      
      if(conc_stmt->_get_label() != NULL) {
	objectname << *(conc_stmt->_get_label()) << ends;
      }
      else {
	objectname << "ANON_PROCESS" << conc_stmt << ends;
      }
      objectname << "_elab_obj" << ends;
      _current_elab_name = objectname.str();
      conc_stmt->_publish_createNetInfo();
      _cc_out << "}\n";
    }
    else if ((conc_stmt->get_kind() == IIR_BLOCK_STATEMENT) ||
	     (conc_stmt->get_kind() == IIR_CONCURRENT_GENERATE_FOR_STATEMENT)||
	     (conc_stmt->get_kind() == IIR_CONCURRENT_GENERATE_IF_STATEMENT)) {
      // Nothing to be done for these guys
    }
    else if (conc_stmt->get_kind() == IIR_COMPONENT_INSTANTIATION_STATEMENT) {
      _publish_cc_generate_for_loop();
      _cc_out << "{\n";
      _publish_cc_assign_to_loop_constant();
      _publish_cc_body_for_component_createNetInfo(conc_stmt);
      _cc_out << "  }\n";
    }
    else {
      cerr << "ERROR! IIRScram_ConcurrentGenerateForStatement::"
	   << "_publish_cc_createNetInfo(): unknown conc_statement "
	   << "type |" << conc_stmt->get_kind_text() << "| in arch" << endl;
    }
    
    delete [] _current_elab_name;
    _current_elab_name = NULL;
    found = FALSE;
    wanted_instantiation = 1;
    conc_stmt = concurrent_statement_part.successor(conc_stmt);
  }
  _cc_out << "}\n\n";
  _current_elab_name    = tmp;
  _current_publish_name = tmp2;
  _current_publish_node = tmpNode;

  _set_currently_publishing_unit(old_publishing_unit);
}

void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_connect()
{
  PublishedUnit oldUnit = _get_currently_publishing_unit();

  _set_currently_publishing_unit(GENERATE_FOR);
  
  _cc_out << "void\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::connect(int inputsignals, int outputsignals, ...) {\n";
  _cc_out << "int NoofSignals = inputsignals + outputsignals;";
  _cc_out << "va_list ap;\n";
  _cc_out << "opFanoutinfo = (VHDLType**)new char[NoofSignals * sizeof(VHDLType*)];\n";

  _cc_out << "  int generateLeft = ";
  ((IIR_ScalarTypeDefinition *) get_generate_parameter_specification()->get_subtype())->get_left()->_publish_cc_value();
  _cc_out << ";\n\n";
  _cc_out << "  int i;\n";
  
  _cc_out << "va_start(ap, outputsignals);\n";
  _cc_out << "for(i = 0; (i < NoofSignals); i++) {\n";
  _cc_out << "  opFanoutinfo[i] = va_arg(ap, VHDLType*);\n";
  _cc_out << "}\n";
  _cc_out << "va_end(ap);\n";
  
  _cc_out << "if(inputsignals > 0) {\n";
  _cc_out << "}\n";

  _cc_out << "if(outputsignals > 0) {\n";
  _cc_out << "}\n";

  IIR_ConcurrentStatement *conc_stmt;
  IIR_Char* objectname_ptr = NULL;
  conc_stmt = concurrent_statement_part.first();
  while (conc_stmt != NULL) {
    ostrstream objectname;
    if (conc_stmt->get_kind() == IIR_COMPONENT_INSTANTIATION_STATEMENT) {
      _publish_cc_generate_for_loop();
      _cc_out << "{\n";
      _publish_cc_assign_to_loop_constant();
      objectname << *(conc_stmt->_get_label()) << "_elab_obj[i]" << ends;
      _current_elab_name = objectname.str();
      objectname_ptr = _current_elab_name;
      ((IIR_ComponentInstantiationStatement*)conc_stmt)->_publish_connect();
      _cc_out << "  }\n";
      delete [] objectname_ptr;
    }
    else if (conc_stmt->_is_concurrent_generate_statement() == TRUE) {
      _publish_cc_generate_for_loop();
      _cc_out << "{\n";
      _publish_cc_assign_to_loop_constant();
      
      conc_stmt->_get_label()->_publish_cc_elaborate();
      if (_get_currently_publishing_unit() == GENERATE_FOR) {
	_cc_out << "_elab_obj[i - generateLeft].connect(0, 0);\n";
      }
      else {
	_cc_out << "->connect(0, 0);\n";
      }
      _cc_out << "  }\n";
    }
    else if (conc_stmt->_is_block_statement() == TRUE) {
      _publish_cc_generate_for_loop();
      _cc_out << "{\n";
      _publish_cc_assign_to_loop_constant();
      
      ((IIR_BlockStatement *) conc_stmt)->_publish_connect();
      
      _cc_out << "  }\n";
    }

    conc_stmt = concurrent_statement_part.successor(conc_stmt);
  }
  _cc_out << "}\n";

  _set_currently_publishing_unit(oldUnit);
}


void
IIRScram_ConcurrentGenerateForStatement::_publish_cc_generate_for_loop_with_zero(char *variable_name)
{
  IIR_ScalarTypeDefinition *range;

  ASSERT ( get_generate_parameter_specification()->get_subtype()->_is_iir_scalar_type_definition() == TRUE );
  range = (IIR_ScalarTypeDefinition *) get_generate_parameter_specification()->get_subtype();
  
  _cc_out << "  for(int " << variable_name << " = ";
  if ( range->_is_ascending_range() == TRUE ){
    _cc_out << "0";
  }
  else {
    _cc_out << "(";
    range->get_left()->_publish_cc_value();
    _cc_out << " - ";
    range->get_right()->_publish_cc_value();
    _cc_out << ")";
  }
  _cc_out << "; (" << variable_name << " ";

  if (range->_is_ascending_range() == TRUE) {
    _cc_out << " <= ";
  }
  else {
    _cc_out << " >= ";
  }

  if ( range->_is_ascending_range() == TRUE ){
    _cc_out << "(";
    range->get_right()->_publish_cc_value();
    _cc_out << " - ";
    range->get_left()->_publish_cc_value();
    _cc_out << ")";
  }
  else {
    _cc_out << "0";
  }
  _cc_out << "); ";

  if (range->_is_ascending_range() == TRUE) {
    _cc_out << variable_name << "++";
  }
  else {
    _cc_out << variable_name << "--";
  }

  _cc_out << ")  ";
}

IIR_Label *
IIRScram_ConcurrentGenerateForStatement::_find_instantiate_label( IIR_SimpleName *to_find ){
  return concurrent_statement_part._find_instantiate_label( to_find );
}
