#ifndef IIRSCRAM_CHARACTER_LITERAL_HH
#define IIRSCRAM_CHARACTER_LITERAL_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_CharacterLiteral.hh,v 1.2 1999/03/09 20:53:20 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_CharacterLiteral.hh"

class IIRScram_CharacterLiteral : public IIRBase_CharacterLiteral {

public:
  // This method takes a C-language character and returns a VHDL character literal
  // with the ' characters on either side.
  static IIR_CharacterLiteral *_get_from_character( char );

protected:
  IIRScram_CharacterLiteral() {}
  virtual ~IIRScram_CharacterLiteral() = 0;
    
private:
};
#endif
