#ifndef IIRSCRAM_ALIAS_DECLARATION_HH
#define IIRSCRAM_ALIAS_DECLARATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_AliasDeclaration.hh,v 1.5 1999/08/26 13:47:04 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_AliasDeclaration.hh"

template <class type> class set;
class IIR_TypeDefinition;
class IIR_List;
class IIR_DesignatorList;
class IIR_AliasDeclaration;

class IIRScram_AliasDeclaration : public IIRBase_AliasDeclaration {

public:
  // See IIRScram_Declaration for internal documentation for these methods.
  void _publish_vhdl_decl(ostream &);
  void _publish_cc();
  void _publish_cc_elaborate();

  void _publish_cc_decl();
  void _publish_cc_decl_original_object();
  void _publish_cc_alias_object_init();
  void _publish_cc_state_object_init();
  void _publish_cc_elaborate_alias_init();
  void _publish_cc_elaborate_alias_definition();
  void _publish_cc_bounds();
  void _publish_cc_type_name();
  void _publish_cc_headers();
  void _publish_cc_constructor_args();

  void _publish_cc_initialization_value();
  void _publish_cc_universal_type();
  
  declaration_type _get_type();
  IIR_TypeDefinition *_get_subtype();
  IIR_Boolean _is_object();
  IIR_Boolean _is_signal();
  IIR_Boolean _is_variable();

  IIR_TypeDefinition *_get_type_of_element( int );
  IIR_Int32 _get_num_indexes();
  void _type_check();

  IIR_Boolean _is_readable();
  IIR_Boolean _is_writable();
  IIR_Boolean _is_array_type();
  IIR_Boolean _is_type();

  IIR_Boolean _is_locally_static_primary();
  IIR_Boolean _is_globally_static_primary();

  void _add_necessary_decls_into_cgen_symbol_table();
  void _add_decl_into_cgen_symbol_table();
  void _add_declarations_in_initializations();
  IIR_Declaration *_get_prefix_declaration();
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  void _set_driver_addition_flag(IIR_Boolean);
  const IIR_Char* _get_mangling_prefix();

  IIR_AttributeSpecificationList* _get_attribute_specification_list(); 

  IIR *_clone();
  IIR_AliasDeclaration *_my_clone;

  void _come_into_scope( symbol_table * );
  void _come_out_of_scope( symbol_table * );

protected:
  IIRScram_AliasDeclaration() { _my_clone = NULL; }
  virtual ~IIRScram_AliasDeclaration() = 0;
    
private:
};
#endif
