
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_ReportStatement.cc,v 1.2 1999/03/09 20:51:36 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_ReportStatement.hh"
#include "savant.hh"

IIRBase_ReportStatement::IIRBase_ReportStatement() {
  set_report_expression(NULL);
  set_severity_expression(NULL);
}

IIRBase_ReportStatement::~IIRBase_ReportStatement() {
  if(report_expression != NULL)
    delete get_report_expression();
  if(severity_expression != NULL)
    delete get_severity_expression();
}

void 
IIRBase_ReportStatement::set_report_expression( IIR* report_expression) {
  this->report_expression  = report_expression;
}

IIR* 
IIRBase_ReportStatement::get_report_expression() {
  return report_expression;
}

void 
IIRBase_ReportStatement::set_severity_expression( IIR* severity_expression) {
  this->severity_expression = severity_expression;
}

IIR* 
IIRBase_ReportStatement::get_severity_expression() {
  return severity_expression;
}

