
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_DeclarationList.cc,v 1.2 1999/03/09 20:49:27 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_DeclarationList.hh"
#include "IIR_Declaration.hh"

IIRBase_DeclarationList::IIRBase_DeclarationList(){}
IIRBase_DeclarationList::~IIRBase_DeclarationList(){}

void 
IIRBase_DeclarationList::append( IIR_Declaration *to_append ){
  ASSERT( to_append->_is_iir_declaration() == TRUE );
  dl_list<IIR>::append( to_append );
}

IIR_Declaration *
IIRBase_DeclarationList::successor( IIR_Declaration *succeed_me ){
  ASSERT( succeed_me->_is_iir_declaration() == TRUE );

  IIR *retval = dl_list<IIR>::successor( succeed_me );
  
  ASSERT( retval == NULL || retval->_is_iir_declaration() == TRUE );

  return (IIR_Declaration *)retval;
}

IIR_Declaration *
IIRBase_DeclarationList::first(){
  IIR *retval = dl_list<IIR>::first();

  ASSERT( retval == NULL || retval->_is_iir_declaration() == TRUE );
  
  return (IIR_Declaration *)retval;
}


void
IIRBase_DeclarationList::prepend( IIR_Declaration *element ) {

  ASSERT( element->_is_iir_declaration() == TRUE );

  IIR_List::prepend( element );
}

IIR_Declaration*
IIRBase_DeclarationList::predecessor( IIR_Declaration *element ){
  ASSERT( element->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );
  
  IIR *retval = IIR_List::predecessor( element );

  ASSERT( retval == NULL || retval->_is_iir_declaration() == TRUE );

  return (IIR_Declaration*)retval;
}


IIR_Declaration *
IIRBase_DeclarationList::last() {
  IIR *retval = IIR_List::last( );

  ASSERT( retval == NULL || retval->_is_iir_declaration() == TRUE );

  return (IIR_Declaration*)retval;
}

IIR_Declaration *
IIRBase_DeclarationList::get_nth_element( IIR_Int32 to_get ){
  IIR *retval = IIR_List::get_nth_element( to_get );

  ASSERT( retval == NULL || retval->_is_iir_declaration() == TRUE );

  return (IIR_Declaration *)retval;
}
