
#ifndef IIRBASE_CONDITIONAL_WAVEFORM_HH
#define IIRBASE_CONDITIONAL_WAVEFORM_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_ConditionalWaveform.hh,v 1.2 1999/03/09 20:49:18 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_Tuple.hh"
#include "IIR_WaveformList.hh"

class IIRBase_ConditionalWaveform : public IIR_Tuple {

public:
  IIR_Kind get_kind() {return IIR_CONDITIONAL_WAVEFORM;}
  IIR_Char *get_kind_text() {return "IIR_ConditionalWaveform";}

  void set_condition( IIR *condition );
  IIR *get_condition();

  IIR_WaveformList waveform;

protected:
  IIRBase_ConditionalWaveform();
  virtual ~IIRBase_ConditionalWaveform() = 0;
    
private:
  IIR *condition;
};
#endif
