
#ifndef IIRBASE_CONCURRENT_PROCEDURE_CALL_STATEMENT_HH
#define IIRBASE_CONCURRENT_PROCEDURE_CALL_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_ConcurrentProcedureCallStatement.hh,v 1.2 1999/03/09 20:49:13 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_ConcurrentStatement.hh"
#include "IIR_AssociationList.hh"
#include "IIR_ConcurrentStatementList.hh"

class IIRBase_ConcurrentProcedureCallStatement : public IIR_ConcurrentStatement {

public:
  IIR_Kind get_kind() {return IIR_CONCURRENT_PROCEDURE_CALL_STATEMENT;}
  IIR_Char *get_kind_text() {return "IIR_ConcurrentProcedureCallStatement";}

  void set_postponed( IIR_Boolean postponed );
  IIR_Boolean get_postponed();

  void set_procedure_name( IIR *procedure_name );
  IIR *get_procedure_name();

  IIR_AssociationList          actual_parameter_part;
  IIR_ConcurrentStatementList  process_statement_part;

protected:
  IIRBase_ConcurrentProcedureCallStatement();
  virtual ~IIRBase_ConcurrentProcedureCallStatement() = 0;
    
private:
  IIR_Boolean postponed;
  IIR *procedure_name;
};
#endif
