
#ifndef IIRBASE_BLOCK_STATEMENT_HH
#define IIRBASE_BLOCK_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_BlockStatement.hh,v 1.2 1999/03/09 20:48:51 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_ConcurrentStatement.hh"
#include "IIR_GenericList.hh"
#include "IIR_AssociationList.hh"
#include "IIR_PortList.hh"
#include "IIR_AssociationList.hh"
#include "IIR_DeclarationList.hh"
#include "IIR_ConcurrentStatementList.hh"

class IIRBase_BlockStatement : public IIR_ConcurrentStatement {

public:
  IIR_Kind get_kind() {return IIR_BLOCK_STATEMENT;}
  IIR_Char *get_kind_text() {return "IIR_BlockStatement";}

  void set_guard_expression( IIR *guard_expression );
  IIR *get_guard_expression();

  IIR_GenericList              generic_clause;
  IIR_AssociationList          generic_map_aspect;
  IIR_PortList                 port_clause;
  IIR_AssociationList          port_map_aspect;
  IIR_DeclarationList          block_declarative_part;
  IIR_ConcurrentStatementList  block_statement_part;

protected:
  IIRBase_BlockStatement();
  virtual ~IIRBase_BlockStatement() = 0;
    
private:
  IIR *guard_expression;
};
#endif
