
#ifndef HASH_TABLE_HH
#define HASH_TABLE_HH

// Copyright (c) 1993-1999 The University of Cincinnati.
// All rights reserved. 

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// Authors: Philip A. Wilsey    phil.wilsey@uc.edu
//          Dale E. Martin      dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: hash_table.hh,v 1.2 1999/03/09 20:57:41 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include <iostream.h>
#include <string.h>
#include "dl_list.hh"

template <class Type>
class hash_table {

// @BeginAutoDocExternalProseDescription

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Template based bucket hashing class.  Hashes on input string.
// The template <Type> defines the type of the constructed bucket for
// each entry.

// Requirements on <Type>:
//        void set_key(char *key): initializes text key in <Type>
//        int test_key(char *key): returns strcmp(key,x) where x is
//                                 internal pointer to text string
//        <Type> constructor assumed to require no arguments

// Defines functions:
//        hash_look(key): look up "key" in the hash table
//        dump(): dump the entries in the hash table (assumes that <<
//                is defined for the instantiated <Type>.

// @EndAutoDocExternalProseDescription
    
public:
    
  Type *hash_look();  

  Type *hash_look( char *text ){
    return hash_look( text, strlen(text) );
  }

  Type *hash_look( char *text, int length ) {
    int key;
    int i;
    Type *wk;

    key = 0;
  
    // calculate a hash value...
    for (i = 0; i < length; i++) {
      key = (key << 3) + text[i];
    }

    key = (key & 0x7fffffff) % ht_size;

    for (wk=ht[key].first();
	 wk!=NULL && wk->test_key( text, length );
	 wk=ht[key].successor(wk)) {}
    
    if (wk == NULL) {
      wk = new Type();
      wk->set_key( text, length );
      ht[key].append(wk);
    }
    
    return wk;
  }
  
//   void dump() {
//     int i;
//     Type *wk;
    
//     for (i=0; i<ht_size; i++) {
//       if (ht[i].num_elements() != 0) {
// 	cout << "ht[" << i << "] =";
// 	for (wk=ht[i].first(); wk!=NULL; wk=ht[i].successor(wk)) {
// 	  cout << " ";
// 	}
// 	cout << "\n";
//       }
//     }      
//   }
    
  
  hash_table(int table_size = 4093) : ht_size(table_size) {
    ht = new dl_list<Type>[ht_size];
  }
    
  ~hash_table(){
    delete [] ht;
  };

  void reset(){
    int i;
    for(i = 0 ; i < ht_size; i++){
      ht[i].destroy_containers();
    }
  }

  const int get_size() const {
    return ht_size;
  }

  dl_list<Type>* get_entry(int entry_number) const {
    ASSERT ( (entry_number >= 0) && (entry_number <= ht_size) );
    return (ht + entry_number);
  }

private:

  const int ht_size;
  dl_list<Type> *ht;
  
};

template <class Type>
inline
Type *
hash_table<Type>::hash_look(){return NULL;}


#endif
