// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_IntegerLiteral32.cc,v 1.2 1999/03/09 20:55:02 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_IntegerLiteral32.hh"

IIRScram_IntegerLiteral32::~IIRScram_IntegerLiteral32() {}

void 
IIRScram_IntegerLiteral32::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << value();
}

ostream &
IIRScram_IntegerLiteral32::_print(ostream &os) {
  _publish_vhdl( os );
  return os;
}


void 
IIRScram_IntegerLiteral32::_publish_cc() {
  _cc_out << value();
}

void 
IIRScram_IntegerLiteral32::_publish_cc_universal_value() {
  _cc_out << "UniversalInteger( (int)" << value() << ")";
}

void 
IIRScram_IntegerLiteral32::_publish_cc_value() {
  _publish_cc_universal_value();
}

IIR_Boolean
IIRScram_IntegerLiteral32::_is_integer_literal() {
  return true;
}
