// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_EntityDeclaration.cc,v 1.4 1999/07/23 21:08:04 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_EntityDeclaration.hh"
#include "IIR_AliasDeclaration.hh"
#include "IIR_ArchitectureDeclaration.hh"
#include "IIR_Attribute.hh"
#include "IIR_ComponentInstantiationStatement.hh"
#include "IIR_ConstantInterfaceDeclaration.hh"
#include "IIR_ConfigurationSpecification.hh"
#include "IIR_Declaration.hh"
#include "IIR_DesignatorExplicit.hh"
#include "IIR_Identifier.hh"
#include "IIR_Label.hh"
#include "IIR_Name.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_UseClause.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "symbol_table.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_EntityDeclaration::IIRScram_EntityDeclaration() {
  cgen_sym_tab_ptr = NULL;
}


IIRScram_EntityDeclaration::~IIRScram_EntityDeclaration() {}



set<IIR_Declaration> *
IIRScram_EntityDeclaration::_find_declarations( IIR_Name *to_find ) {
  set<IIR_Declaration> *retval = new set<IIR_Declaration>;

  set<IIR_Declaration> *current_set = port_clause._find_declarations( to_find );
  if( current_set != NULL ){
    retval->add( current_set );
    delete current_set;
  }

  current_set = generic_clause._find_declarations( to_find );
  if( current_set != NULL ){
    retval->add( current_set );
    delete current_set;
  }


  current_set = entity_declarative_part._find_declarations( to_find );
  if( current_set != NULL ){
    retval->add( current_set );
    delete current_set;
  }


  if( retval->num_elements() == 0 ){
    delete retval;
    retval = NULL;
  }
  
  return retval;
}


void 
IIRScram_EntityDeclaration::_make_interface_visible( symbol_table *sym_tab ) {
  ASSERT( sym_tab != NULL );

  context_items._make_visible_as_context_list( sym_tab );
  sym_tab->make_visible( this );
  sym_tab->make_visible( &generic_clause );
  sym_tab->make_visible( &port_clause );
  sym_tab->make_visible( &entity_declarative_part );
}


IIR_PortList *
IIRScram_EntityDeclaration::_get_port_list(){
  return &port_clause;
}


IIR_GenericList *
IIRScram_EntityDeclaration::_get_generic_list(){
  return &generic_clause;
}


IIR_TypeDefinition *
IIRScram_EntityDeclaration::_get_subtype(){
  return NULL;
}


IIRScram_Declaration::declaration_type 
IIRScram_EntityDeclaration::_get_type() {
  return ENTITY;
}


IIR_EntityDeclaration*
IIRScram_EntityDeclaration::_get_entity() {
  return (IIR_EntityDeclaration*)this;
}


void 
IIRScram_EntityDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  context_items._publish_vhdl(_vhdl_out);
  PublishedUnit oldUnit = _get_currently_publishing_vhdl_unit();

  _set_currently_publishing_vhdl_unit(ENTITY_DECL);
  
  _vhdl_out << "\nentity ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " is\n";

  if(generic_clause.num_elements() != 0) {
    _vhdl_out << "generic (\n";
    generic_clause._publish_vhdl(_vhdl_out);
    _vhdl_out << ");\n";
  }

  if(port_clause.num_elements() != 0) {
    _vhdl_out << " port (\n";
    port_clause._publish_vhdl(_vhdl_out);
    _vhdl_out << ");\n";
  }

  entity_declarative_part._publish_vhdl_decl(_vhdl_out);

  if( entity_statement_part.num_elements() != 0) {
    _vhdl_out << "begin\n";
    entity_statement_part._publish_vhdl(_vhdl_out);
  }
  _vhdl_out << "end entity ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n\n";

  _set_currently_publishing_vhdl_unit(oldUnit);
}


void 
IIRScram_EntityDeclaration::_publish_vhdl(ostream &_vhdl_out) {
  get_declarator()->_publish_vhdl(_vhdl_out);
}


void 
IIRScram_EntityDeclaration::_publish_cc() {
  ostrstream ent_name;
  IIR *old_node = _current_publish_node;
  symbol_table cgen_sym_tab( 4093, false );
  
  cgen_sym_tab_ptr = &cgen_sym_tab;

  ent_name << *(IIR_Identifier*)_get_declarator() << ends;
  _current_publish_name = "SE";
  _current_entity_name = ent_name.str();

  _set_currently_publishing_unit(ENTITY_DECL);

  _cc_out.set_file(TRUE, _current_entity_name, "_decls.hh");
  _cc_out << "#ifndef " << _current_entity_name << "_DECLS_HH\n";
  _cc_out << "#define " << _current_entity_name << "_DECLS_HH\n\n";

  _cc_out << endl << "#include \"standard.hh\"" << endl;
  _cc_out << "#include \"textio.hh\"\n\n";

  context_items._publish_cc();
  generic_clause._publish_cc_elaborate_as_pointers(FALSE);
  entity_declarative_part._publish_cc_extern_type_info();
  entity_declarative_part._publish_cc();

  _cc_out.set_file(TRUE, _current_entity_name, "_decls.hh");
  _cc_out << "#endif\n";

  _current_publish_node = this;
  _cc_out.set_file(TRUE, _current_entity_name, "_decls.cc");
  _cc_out << "#include \"" << _current_entity_name << "_decls.hh\"" 
	  << endl << endl;
  generic_clause._publish_cc_elaborate_as_pointers(TRUE);
  entity_declarative_part._publish_cc_decl();

  entity_statement_part._publish_cc();
  _current_publish_node = old_node;
  _set_currently_publishing_unit(NONE);

  //delete [] _current_publish_name;
  cgen_sym_tab_ptr = NULL;
}


void
IIRScram_EntityDeclaration::_publish_cc_elaborate() {
  _publish_cc_headerfile();
  _publish_cc_ccfile();
  _publish_cc_component_decl();
}


void
IIRScram_EntityDeclaration::_publish_cc_headerfile() {
  ostrstream filename;

  filename << "SE";
  _get_declarator()->_print(filename);
  filename << "_elab" << ends;
  _cc_out.set_file(TRUE, filename.str(), ".hh", TRUE);
  _cc_out <<"#ifndef" << "  __" << filename.str() << "__HH__" <<endl;
  _cc_out <<"#define" << "  __" << filename.str() << "__HH__" <<endl;
  _cc_out <<"#include \"_savant_entity_elab.hh\"" << endl;
  _cc_out <<"#include \"SignalNetinfo.hh\"" << endl;

  // All the declarations are included through this file 
  _cc_out << "#include \"";
  _get_declarator()->_publish_cc();
  _cc_out << "_decls.hh\"\n";
  entity_declarative_part._publish_cc_extern_type_info();
  _publish_cc_class_includes(&entity_statement_part);
  _publish_cc_class();
  _cc_out << "#endif" << endl;
}


void
IIRScram_EntityDeclaration::_publish_cc_class() {
  _cc_out <<"class ";
  this->_publish_cc_binding_name();
  _cc_out << "_elab : public ";
  _cc_out <<"_savant_entity_elab {\n" ;
  _cc_out << "public:\n";

  _cc_out << "\n\n";

  this->_publish_cc_binding_name();
  _cc_out << "_elab();\n";

  if(generic_clause.num_elements() > 0) {
    this->_publish_cc_binding_name();    
    _cc_out << "_elab(\n";
    generic_clause._publish_generic_parameter_list();
    _cc_out << " );\n";
  }

  _cc_out << "~";
  this->_publish_cc_binding_name();
  _cc_out << "_elab();\n";

  _cc_out << "\n\n";

  generic_clause._publish_cc_elaborate();
  port_clause._publish_cc_elaborate();
  //Aliases for signal objects are also published
  _publish_cc_signals(&entity_declarative_part);
  _publish_cc_object_pointers(&entity_statement_part);

  if (generic_clause.first() != NULL) {
    _cc_out << "  void copyGenericsToGlobals();\n";
  }
  
  _cc_out << "};\n";

}

void
IIRScram_EntityDeclaration::_publish_cc_object_pointers_init() {
  IIRScram::_publish_cc_object_pointers_init(&entity_statement_part, &entity_declarative_part);
}


///####WARNING THIS PROCEDURE NEEDS A LOT OF WORK TO KEEP THIS MODULARIZED
void
IIRScram_EntityDeclaration::_publish_cc_createNetInfo() {
  IIR_ConcurrentStatement* conc_stmt;
  ostrstream objectname;
  int found = 0;
  //Publishing createNetInfo from entity statement part
  conc_stmt = entity_statement_part.first();
  while (conc_stmt != NULL) {
    ostrstream objectname;
    if (conc_stmt->get_kind() == IIR_PROCESS_STATEMENT) {
      if(conc_stmt->get_label() != NULL) {
	objectname << *(conc_stmt->get_label()) << ends;
      }
      else {
	objectname << "ANON_PROCESS" << conc_stmt << ends;
      }
      objectname << "_elab_obj" << ends;
      _current_elab_name = objectname.str();
      conc_stmt->_publish_createNetInfo();
    }
    else if (conc_stmt->get_kind() == IIR_COMPONENT_INSTANTIATION_STATEMENT) {
      IIR_Name* componentname = (IIR_Name *)((IIR_ComponentInstantiationStatement*)conc_stmt)->get_instantiated_unit();
      //Searching for configuration specification
      if(componentname->get_prefix()->get_kind() == IIR_COMPONENT_DECLARATION) {
	IIR_Declaration* decl = entity_declarative_part.first();
	while(decl != NULL) {
	  if(decl->get_kind() == IIR_CONFIGURATION_SPECIFICATION) {
	    if(componentname->get_prefix() == ((IIR_ConfigurationSpecification*)decl)->get_component_name()) {
	      IIR_Designator* designator =((IIR_ConfigurationSpecification*)decl)->instantiation_list.first();
	      //By_others, By_all follows By_Explicit
	      while(designator != NULL) {
		switch(designator->get_kind()) {
		case IIR_DESIGNATOR_EXPLICIT:
		  if(((IIR_DesignatorExplicit*)designator)->get_name() == conc_stmt->get_label()) {
		    found = 1;
		    if(((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements() == 0) {
		      _current_publish_node = componentname->get_prefix();
		      objectname << "(( ";
		      IIR_LibraryUnit* lib_unit =((IIR_ConfigurationSpecification*)decl)->get_entity_aspect(); 
		      if(lib_unit->get_kind() == IIR_ENTITY_DECLARATION) {
			objectname << *(((IIR_ConfigurationSpecification*)decl)->get_entity_aspect()->_get_declarator());
		      }
		      else if(lib_unit->get_kind() == IIR_ARCHITECTURE_DECLARATION) {
			IIR_ArchitectureDeclaration* arch_decl = (IIR_ArchitectureDeclaration*)((IIR_ConfigurationSpecification*)decl)->get_entity_aspect();
			objectname << *(arch_decl->get_entity()->_get_declarator());
			objectname << "_";
			objectname << *(arch_decl->_get_declarator());
		      }
		      else {
			//Nothing to be done for now
		      }
		      objectname << "_elab*) " << *(conc_stmt->get_label());
		      objectname << "_elab_obj->boundedEntity)->" << ends;
		      _current_publish_name = objectname.str();
		      ((IIR_EntityDeclaration*)((IIR_ConfigurationSpecification*)decl)->get_entity_aspect())->port_clause._publish_cc_port_map_aspect();
		    }
		    else {
		      _current_publish_node = componentname->get_prefix();
		      objectname << "(( ";
		      IIR_LibraryUnit* lib_unit =((IIR_ConfigurationSpecification*)decl)->get_entity_aspect(); 
		      if(lib_unit->get_kind() == IIR_ENTITY_DECLARATION) {
			objectname << *(((IIR_ConfigurationSpecification*)decl)->get_entity_aspect()->_get_declarator());
		      }
		      else if(lib_unit->get_kind() == IIR_ARCHITECTURE_DECLARATION) {
			IIR_ArchitectureDeclaration* arch_decl = (IIR_ArchitectureDeclaration*)((IIR_ConfigurationSpecification*)decl)->get_entity_aspect();
			objectname << *(arch_decl->get_entity()->_get_declarator());
			objectname << "_";
			objectname << *(arch_decl->_get_declarator());
		      }
		      else {
			//Nothing to be done for now
		      }
		      objectname << "_elab*) " << *(conc_stmt->get_label());
		      objectname << "_elab_obj->boundedEntity)->" << ends;
		      _current_publish_name = objectname.str();
		      ((IIR_ConfigurationSpecification*)decl)->port_map_aspect._publish_cc_elaborate();
		    }
		  }
		  break;
		case IIR_DESIGNATOR_BY_ALL:
		case IIR_DESIGNATOR_BY_OTHERS:
		  found = 1;
		  if(((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements() == 0) {
		    _current_publish_node = componentname->get_prefix();
		    objectname << "(( ";
		    IIR_LibraryUnit* lib_unit =((IIR_ConfigurationSpecification*)decl)->get_entity_aspect(); 
		    if(lib_unit->get_kind() == IIR_ENTITY_DECLARATION) {
		      objectname << *(((IIR_ConfigurationSpecification*)decl)->get_entity_aspect()->_get_declarator());
		    }
		    else if(lib_unit->get_kind() == IIR_ARCHITECTURE_DECLARATION) {
		      IIR_ArchitectureDeclaration* arch_decl = (IIR_ArchitectureDeclaration*)((IIR_ConfigurationSpecification*)decl)->get_entity_aspect();
		      objectname << *(arch_decl->get_entity()->_get_declarator());
		      objectname << "_";
		      objectname << *(arch_decl->_get_declarator());
		    }
		    else {
		      //Nothing to be done for now
		    }
		    objectname << "_elab*) " << *(conc_stmt->get_label());
		    objectname << "_elab_obj->boundedEntity)->" << ends;
		    _current_publish_name = objectname.str();
		    ((IIR_EntityDeclaration*)((IIR_ConfigurationSpecification*)decl)->get_entity_aspect())->port_clause._publish_cc_port_map_aspect();
		  }
		  else {
		    _current_publish_node = componentname->get_prefix();
		    objectname << "(( ";
		    IIR_LibraryUnit* lib_unit =((IIR_ConfigurationSpecification*)decl)->get_entity_aspect(); 
		    if(lib_unit->get_kind() == IIR_ENTITY_DECLARATION) {
		      objectname << *(((IIR_ConfigurationSpecification*)decl)->get_entity_aspect()->_get_declarator());
		    }
		    else if(lib_unit->get_kind() == IIR_ARCHITECTURE_DECLARATION) {
		      IIR_ArchitectureDeclaration* arch_decl = (IIR_ArchitectureDeclaration*)((IIR_ConfigurationSpecification*)decl)->get_entity_aspect();
		      objectname << *(arch_decl->get_entity()->_get_declarator());
		      objectname << "_";
		      objectname << *(arch_decl->_get_declarator());
		    }
		    else {
		      //Nothing to be done for now
		    }
		    objectname << "_elab*) " << *(conc_stmt->get_label());
		    objectname << "_elab_obj->boundedEntity)->" << ends;
		    _current_publish_name = objectname.str();
		    ((IIR_ConfigurationSpecification*)decl)->port_map_aspect._publish_cc_elaborate();
		  }
		  break;
		}
		if(found ==1) {
		  ///Has to exit the two enclosing loops
		  designator = NULL;
		  decl = NULL;
		}
		else {
		  designator =((IIR_ConfigurationSpecification*)decl)-> instantiation_list.successor(designator);
		}
	      }
	    }
	  }
	  decl = entity_declarative_part.successor(decl);
	}
      }
      //###yet to check for label
      objectname << *(conc_stmt->get_label()) << "_elab_obj" << ends;
      _current_elab_name = objectname.str();
      conc_stmt->_publish_createNetInfo();
    }
    else {
      cerr << "ERROR! IIRScram_EntityDeclaration::"
	   << "_publish_cc_createNetInfo(): unknown conc_statement "
	   << "type |" << conc_stmt->get_kind_text() << "| in entity" << endl;
      abort();
    }
    delete [] _current_elab_name;
    _current_elab_name = NULL;
    conc_stmt = entity_statement_part.successor(conc_stmt);
  }
}


void
IIRScram_EntityDeclaration::_publish_cc_binding_name(ostream& outstream) {
  outstream << "SE";
  //  _get_declarator()->_publish_cc_elaborate();
  _get_declarator()->_print(outstream);
}

void
IIRScram_EntityDeclaration::_publish_cc_ccfile() {
  ostrstream filename;

  filename << "SE";
  _get_declarator()->_print(filename);
  filename << "_elab" << ends;
  _cc_out.set_file(TRUE, filename.str(), ".cc", TRUE);

  _cc_out << "#include \"" << filename.str() << ".hh\"\n";
  _cc_out << "#ifdef SEQUENTIAL" << endl;
  _cc_out << "#include \"BaseSequential.hh\" " << endl;
  _cc_out << "#define OBJTYPE BaseSequential" << endl;
  _cc_out << "#else" << endl;
  _cc_out << "#include \"BasicTimeWarp.hh\" " << endl;
  _cc_out << "#define OBJTYPE BasicTimeWarp" << endl;
  _cc_out << "#endif" << endl;

  _cc_out << "extern OBJTYPE* proc_array[];\n";
  entity_declarative_part._publish_cc_type_info();
  _publish_cc_headerfiles_for_cc();
  _publish_cc_constructor();
  _publish_cc_destructor(&entity_statement_part);

  if (generic_clause.first() != NULL) {
    _publish_cc_copy_generics_to_globals();
  }
    
  //  _publish_cc_partition();
}


void
IIRScram_EntityDeclaration::_publish_cc_headerfiles_for_cc() {
  IIR_Declaration* decl;
  IIR_ConcurrentStatement* conc_stmt;

  _cc_out << "#include \"ObjectBase.hh\"\n";
  decl = entity_declarative_part.first();
  while(decl != NULL) {
    if( decl->get_kind() == IIR_CONFIGURATION_SPECIFICATION ) {
      _cc_out << "#include \"";
      ((IIR_ConfigurationSpecification*)decl)->get_entity_aspect()->_publish_cc_binding_name();
      _cc_out << "_elab.hh\"\n";
    }
    decl =  entity_declarative_part.successor(decl);
  }

  conc_stmt = entity_statement_part.first();
  while (conc_stmt != NULL) {
    //###currently the process name doesn't include its entity and
    //architecture name
    if( conc_stmt->get_kind() == IIR_PROCESS_STATEMENT ) {
      _cc_out << "#include \"";
      conc_stmt->_publish_cc_binding_name( _cc_out );
      _cc_out << ".hh\"\n";
    }
    //Nothing to be done for other statements
    conc_stmt = entity_statement_part.successor( conc_stmt );
  }
}


void
IIRScram_EntityDeclaration::_publish_cc_constructor() {
  _publish_cc_constructor_with_no_arguments();
  if (generic_clause.num_elements() > 0) {
    _publish_cc_constructor_with_arguments();
  }
}


void
IIRScram_EntityDeclaration::_publish_cc_constructor_with_no_arguments() {
  int numGenericClause = generic_clause.num_elements();
  int numPortClause = port_clause.num_elements();

  this->_publish_cc_binding_name();
  _cc_out << "_elab";
  _cc_out << "::";
  this->_publish_cc_binding_name();
  _cc_out << "_elab()";

  if(numGenericClause > 0) {
    _cc_out << ":\n";
    generic_clause._publish_generic_init();
    if(numPortClause > 0) {
      _cc_out << ",\n";
      port_clause._publish_cc_port_init();
    }
  }
  else {
    if(numPortClause > 0) {
      _cc_out << ":\n";
      port_clause._publish_cc_port_init();
    }
  }
  _publish_cc_signal_objects_init();
  _cc_out << " {\n";
  // before newing the elab guys down the heirarchy copy generics of this entity 
  // to the global generic pointers in the entity_decls file
  if (numGenericClause > 0) {
    _cc_out << " copyGenericsToGlobals();\n";
  }
  _publish_cc_object_pointers_init();
  _cc_out << "}\n";
}


void
IIRScram_EntityDeclaration::_publish_cc_constructor_with_arguments() {
  int numGenericClause = generic_clause.num_elements();
  int numPortClause = port_clause.num_elements();

  this->_publish_cc_binding_name();
  _cc_out << "_elab::";
  this->_publish_cc_binding_name();
  _cc_out << "_elab(\n";
  generic_clause._publish_generic_parameter_list();
  _cc_out << " )";

  if(numGenericClause > 0) {
    _cc_out << ":\n";
    generic_clause._publish_generic_init_by_arguments();
    if(numPortClause > 0) {
      _cc_out << ",\n";
      port_clause._publish_cc_port_init();
    }
  }
  else {
    if(numPortClause > 0) {
      _cc_out << ":\n";
      port_clause._publish_cc_port_init();
    }
  }
  _publish_cc_signal_objects_init();
  _cc_out << " {\n";
  // before newing the elab guys down the heirarchy copy generics of this entity 
  // to the global generic pointers in the entity_decls file
  if (numGenericClause > 0) {
    _cc_out << " copyGenericsToGlobals();\n";
  }
  _publish_cc_object_pointers_init();
  _cc_out << "}\n";
}


void
IIRScram_EntityDeclaration::_publish_cc_component_decl() {

  IIR_Declaration *decl;
  decl = entity_declarative_part.first();
  while (decl != NULL) {
    if (decl->get_kind() == IIR_COMPONENT_DECLARATION) {
      decl->_publish_cc_elaborate();
    }  
    decl = entity_declarative_part.successor(decl);
  }
}


void
IIRScram_EntityDeclaration::_publish_cc_signal_objects_init() {
  IIR_Declaration* decl;
  decl = entity_declarative_part.first();
  int first = 0;
  int numGenericClause = generic_clause.num_elements();
  int numPortClause = port_clause.num_elements();
  while (decl != NULL) {
    if (decl->get_kind() == IIR_SIGNAL_DECLARATION) {
      if((first == 0)&& (numGenericClause == 0)&& (numPortClause ==0)) {
	_cc_out << ":\n";
	first = 1;
      }
      else {
	_cc_out << ",\n";
      }
      decl->_publish_cc_elaborate();
      _cc_out << "(ObjectBase::SIGNAL_NETINFO";
      if(((IIR_SignalDeclaration*)decl)->get_subtype()->_is_array_type()) {
	_cc_out << ", ";
	((IIR_SignalDeclaration*)decl)->get_subtype()->_publish_cc_range();
      }
      _cc_out << ")";
      // If the Signals has implicit signals, they are also needed for
      // elaboration info
      if( decl->_get_implicit_declarations() != NULL &&
          decl->_get_implicit_declarations()->num_elements() != 0) {
	IIR_Declaration* imp_decl = decl->_get_implicit_declarations()->get_element();
	while(imp_decl != NULL) {
	  if(imp_decl->_is_signal() == TRUE) {
	    _cc_out << ",\n";
	    (imp_decl->_get_declarator())->_publish_cc_elaborate();
	    _cc_out << "(ObjectBase::SIGNAL_NETINFO";
	    IIR_TypeDefinition* type_def = imp_decl->_get_attribute_name()->_get_explicit_signal_type();
	    if((type_def->_is_array_type() == TRUE ) &&
	       (type_def->_is_anonymous() == TRUE)) {
	      _cc_out << ", ";
	      type_def->_publish_cc_range();
	    }	
	    _cc_out << ")";
	  }
	  imp_decl = decl->_get_implicit_declarations()->get_next_element();
	}
      }
    }
    else if(decl->get_kind() == IIR_ALIAS_DECLARATION) {
      if(((IIR_AliasDeclaration*)decl)->get_name()->_is_signal()) {
	if((first == 0)&& (numGenericClause == 0)&& (numPortClause ==0)) {
	  _cc_out << ":\n";
	  first = 1;
	}
	else {
	  _cc_out << ",\n";
	}
	((IIR_AliasDeclaration*)decl)->_publish_cc_elaborate_alias_init();
      }
    }
    decl = entity_declarative_part.successor(decl);
  }
}


#ifdef PROCESS_COMBINATION
void 
IIRScram_EntityDeclaration::_static_elaborate(IIR_ArchitectureDeclaration *arch, 
					      IIR_DeclarationList *cfglist, 
					      char *hier_location) {
  if (generic_clause.num_elements() != 0) {
    cerr << "Sorry, generics in entity declarations not handled in static "
	 << "elaboration yet!" << endl;  
    cerr << "The offending entity is |" << *get_declarator() << "|" << endl;

  }
  if (entity_statement_part.num_elements() != 0) {
    cerr << "Sorry, the entity declarative part not handled in static "
	 << "elaboration yet!" << endl;
    cerr << "The offending entity is |" << *get_declarator() << "|" << endl;
  }

  IIR_Declaration *decl = context_items.first();
  while ( decl != NULL ) {
    ASSERT( IIR_USE_CLAUSE == decl->get_kind() );
    if (arch->context_items.get_position( decl ) == -1 ) {
      arch->context_items.append( decl );
    }
    decl = context_items.successor( decl );
  }
}
#endif


void
IIRScram_EntityDeclaration::_publish_vhdl_binding_name(ostream &_vhdl_out){
  _vhdl_out << " entity ";
  get_declarator()->_publish_vhdl(_vhdl_out);
}


void
IIRScram_EntityDeclaration::_publish_vhdl_with_library_name(ostream &_vhdl_out){
  _vhdl_out << " entity ";
  ASSERT(_get_declarative_region() != NULL);
  ASSERT(_get_declarative_region()->get_kind() == IIR_LIBRARY_DECLARATION);
  _get_declarative_region()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ".";
  get_declarator()->_publish_vhdl(_vhdl_out);
}

void 
IIRScram_EntityDeclaration::_type_check(){
  entity_declarative_part._type_check_attribute_specifications( entity_statement_part );
  entity_declarative_part._type_check_disconnection_specifications( );
}
