#ifndef IIRSCRAM_CONCURRENT_CONDITIONAL_SIGNAL_ASSIGNMENT_HH
#define IIRSCRAM_CONCURRENT_CONDITIONAL_SIGNAL_ASSIGNMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConcurrentConditionalSignalAssignment.hh,v 1.3 1999/03/25 02:57:21 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ConcurrentConditionalSignalAssignment.hh"

class IIR_SignalDeclaration;

class IIRScram_ConcurrentConditionalSignalAssignment : public IIRBase_ConcurrentConditionalSignalAssignment {
public:
  void _publish_vhdl(ostream &);
  IIR *_transmute();
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);

  void _type_check();
  void _type_check_target_and_waveforms();
  IIR_Boolean _is_resolved();
  
  IIR *_clone();
#ifdef PROCESS_COMBINATION
  void _static_elaborate(IIR_ArchitectureDeclaration*, IIR_DeclarationList*, char*);
#endif

  IIR *_get_target();
  void _set_target( IIR * );
  
  IIR_DelayMechanism _get_delay_mechanism();
  void _set_delay_mechanism( IIR_DelayMechanism );

  IIR *_get_reject_time_expression();
  void _set_reject_time_expression( IIR * );

  IIR_SignalDeclaration *_get_guard_signal(){ return _my_guard_signal; }
  void _set_guard_signal( IIR_SignalDeclaration *gs ){ _my_guard_signal =  gs; }

protected:
  IIRScram_ConcurrentConditionalSignalAssignment(){ _my_guard_signal = NULL; }
  virtual ~IIRScram_ConcurrentConditionalSignalAssignment() = 0;
    
private:
  IIR_SignalDeclaration *_my_guard_signal;
};
#endif

