// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V.Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_CaseStatementAlternativeByOthers.cc,v 1.3 1999/09/01 02:11:22 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_CaseStatementAlternativeByOthers.hh"

IIRScram_CaseStatementAlternativeByOthers::~IIRScram_CaseStatementAlternativeByOthers() {}


void 
IIRScram_CaseStatementAlternativeByOthers::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << "when others";

  if (sequence_of_statements.first() != NULL) {
    _vhdl_out << " =>\n";
    sequence_of_statements._publish_vhdl(_vhdl_out);
  }
  else if (_get_currently_publishing_vhdl_unit() == CASE_STATEMENT) {
    _vhdl_out << " =>\n";
  }
}


void 
IIRScram_CaseStatementAlternativeByOthers::_publish_cc() {
  _cc_out << "else {\n";
  sequence_of_statements._publish_cc();
  _cc_out << "}\n";
}

ostream &
IIRScram_CaseStatementAlternativeByOthers::_print( ostream &os ){
  os << "others ";
  return os;
}


IIR*
IIRScram_CaseStatementAlternativeByOthers::_clone() {
  IIR_CaseStatementAlternativeByOthers *clone;
  clone = new IIR_CaseStatementAlternativeByOthers;
  IIRScram_CaseStatementAlternative::_clone(clone);

  return clone;
}
