// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ArraySubtypeDefinition.cc,v 1.4 1999/03/16 21:09:58 dmadhava Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_ArraySubtypeDefinition.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_Identifier.hh"
#include "IIR_TypeDeclaration.hh"
#include "IIR_Attribute.hh"
#include "IIRScram_IntegerLiteral.hh"

IIRScram_ArraySubtypeDefinition::~IIRScram_ArraySubtypeDefinition() {}

void 
IIRScram_ArraySubtypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  IIR_TypeDefinition *node ;
  int index, max_index ;
  
  ASSERT(_get_index_subtype() != NULL );
  ASSERT(get_element_subtype() != NULL );
  
  if ( get_resolution_function() != NULL )  {
    get_resolution_function()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " ";
  }
  
  get_base_type()->_publish_vhdl(_vhdl_out);
  ASSERT ( get_base_type()->_get_index_subtype() != NULL );
  
  if ((get_base_type()->_is_unconstrained_array_type() == TRUE) ||
      (get_base_type()->_get_index_subtype()->_is_enumeration_type() == TRUE)){
    
    _vhdl_out << " ( ";
    
    index = 1 ;
    max_index = _get_num_indexes();
    for (node = this; (index <= max_index); index++, node = node->_get_element_subtype())  {
      ASSERT(node->_is_array_type() == TRUE );
      ASSERT(node->_get_index_subtype() != NULL );
      ASSERT(node->_get_element_subtype() != NULL );
      
      // The next assertion is invalid - what about
      // subtype foo1 is memory (1 to 10);
      //    ASSERT(node->_get_index_subtype()->_get_type_mark() != NULL);

      if (index > 1) {
	_vhdl_out << ", ";
      }
      
      node->_get_index_subtype()->_publish_vhdl_index(_vhdl_out);
    }
    
    _vhdl_out << " ) ";
    
    if ( get_base_type()->_is_anonymous() == TRUE )  {
      _vhdl_out << " of ";
      node->_publish_vhdl(_vhdl_out);
    }
  }
}

void
IIRScram_ArraySubtypeDefinition::_publish_vhdl_subtype_decl(ostream &_vhdl_out){
  _publish_vhdl_decl(_vhdl_out);
}

IIR_ScalarTypeDefinition *
IIRScram_ArraySubtypeDefinition::_get_index_subtype(){
  if(get_index_subtype() != NULL) {
    return get_index_subtype();
  } else {
    ASSERT(get_base_type() != NULL);
    return get_base_type()->_get_index_subtype();
  }
}

IIR_Boolean
IIRScram_ArraySubtypeDefinition::_is_subtype() {
  return TRUE;
}

ostream&
IIRScram_ArraySubtypeDefinition::_print(ostream &os) {
  if( get_base_type()->_get_declaration() != NULL ){
    os << *((IIR_TypeDeclaration *) get_base_type()->_get_declaration())->get_declarator();
  }
  else{
    os << "ANONYMOUS";
  }
  return os;
}

void 
IIRScram_ArraySubtypeDefinition::_publish_cc_type_name() {
  IIR_TypeDeclaration *decl;

  if(_is_anonymous() == TRUE) {
    if(get_base_type() == NULL) {
      _publish_cc_anonymous_type_name();
      return;
    }
    else if(get_base_type()->_is_anonymous() == TRUE) {
      _publish_cc_anonymous_type_name();
      return;
    }
  }
  
  ASSERT(get_base_type() != NULL);
  if( _get_declaration() != NULL){
    decl = (IIR_TypeDeclaration *) _get_declaration();
  } else {
    decl = (IIR_TypeDeclaration *) get_base_type()->_get_declaration();
  }
  ASSERT(decl != NULL);
  _cc_out << "Savant" << decl->_get_declarator()->_convert_to_c_string() 
	  << "Type";
}

void 
IIRScram_ArraySubtypeDefinition::_publish_cc_bounds() {
  _cc_out << "ArrayInfo(";
  _get_index_subtype()->_publish_cc_range();
  _cc_out << ")";
}

void 
IIRScram_ArraySubtypeDefinition::_publish_cc_headers() {
  ASSERT(get_base_type() != NULL);
  if(!get_base_type()->_is_anonymous()){
    _cc_out << "#include \"";
    if (get_base_type()->_is_scalar_type() == TRUE &&
	get_base_type()->_is_kernel_type() == FALSE){
      get_base_type()->_publish_cc_kernel_type();
    }
    else {
      get_base_type()->_publish_cc_type_name();
    }
    _cc_out << ".hh\"" << endl;
  }
  IIRScram_ArrayTypeDefinition::_publish_cc_headers();
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_decl_array_type_attributes() {
    _cc_out << "static const ScalarType LEFT(const IntegerType& n);" 
	  << endl;
  _cc_out << "static const ScalarType RIGHT(const IntegerType& n);" 
	  << endl;
  _cc_out << "static const ScalarType HIGH(const IntegerType& n);" 
	  << endl;
  _cc_out << "static const ScalarType LOW(const IntegerType& n);" 
	  << endl;
  _cc_out << "static const IntegerType LENGTH("
	  << "const IntegerType& n);" << endl;
  _cc_out << "static const EnumerationType ASCENDING("
	  << "const IntegerType& n);" << endl;
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_define_array_type_attributes() {
  _publish_cc_define_type_attribute_left();
  _publish_cc_define_type_attribute_right();
  _publish_cc_define_type_attribute_low();
  _publish_cc_define_type_attribute_high();
  _publish_cc_define_type_attribute_length();
  _publish_cc_define_type_attribute_ascending();
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_define_type_attribute_left() {
  IIR_Int32 indices = _get_num_indexes();
  IIR_TypeDefinition *node = this;

  _cc_out << "const ScalarType"  << endl;
  _publish_cc_type_name();
  _cc_out << "::LEFT(const IntegerType& n) {" << endl
	  << "int val = ((UniversalInteger &) n.object->readVal()).val;" <<endl
	  << "switch(val) {" << endl;

  for(register IIR_Int32 i = 1; i <= indices; i++) {
    _cc_out << "case " << i << ":" << endl
	    << "  return ";
     if (node->_get_index_subtype()->_get_attribute()!=NULL){   
       if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	 node->_get_index_subtype()->get_left()->_publish_cc_type_name();    
	 _cc_out << "(ObjectBase::VARIABLE, ";
	 ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_left();
      }
      if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	node->_get_index_subtype()->get_right()->_publish_cc_type_name();    
	_cc_out << "(ObjectBase::VARIABLE, ";
        ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_right();
      }
      _cc_out << ")";
    }
     else if(node->_get_index_subtype()->get_left()->_is_object() == TRUE) {
       node->_get_index_subtype()->get_left()->_publish_cc_type_name();      
       _cc_out << "(ObjectBase::VARIABLE, ";
       node->_get_index_subtype()->get_left()->_publish_cc();
       _cc_out << ")";
       }
    else {
      node->_get_index_subtype()->get_left()->_publish_cc();
    }
    _cc_out << ";" << endl
	    << "  break;" << endl;
    node = _get_element_subtype();
  }
  _cc_out << "default:" << endl
	  << "cerr << \"Index not int range.\" << endl;" << endl
	  << "abort();" << endl
	  << "break;" << endl
	  << "}" << endl
	  << "}" << endl;
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_define_type_attribute_right() {
  IIR_Int32 indices = _get_num_indexes();
  IIR_TypeDefinition *node = this;

  _cc_out << "const ScalarType"  << endl;
  _publish_cc_type_name();
  _cc_out << "::RIGHT(const IntegerType& n) {" << endl
	  << "int val = ((UniversalInteger &) n.object->readVal()).val;" <<endl
	  << "switch(val) {" << endl;

  for(register IIR_Int32 i = 1; i <= indices; i++) {
    _cc_out << "case " << i << ":" << endl
	    << "  return ";
    if (node->_get_index_subtype()->_get_attribute()!=NULL){
      if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	node->_get_index_subtype()->get_left()->_publish_cc_type_name();    
	_cc_out << "(ObjectBase::VARIABLE, ";
        ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_right();
      }
      if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	node->_get_index_subtype()->get_right()->_publish_cc_type_name();    
	_cc_out << "(ObjectBase::VARIABLE, ";
        ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_left();
      }
      _cc_out << ")";
    }
     else if(node->_get_index_subtype()->get_right()->_is_object() == TRUE) {
       node->_get_index_subtype()->get_right()->_publish_cc_type_name();    
       _cc_out << "(ObjectBase::VARIABLE, ";
       node->_get_index_subtype()->get_right()->_publish_cc();
       _cc_out << ")";
     }
    else {
      node->_get_index_subtype()->get_right()->_publish_cc();
    }
    _cc_out << ";" << endl
	    << "  break;" << endl;
    node = _get_element_subtype();
  }
  _cc_out << "default:" << endl
	  << "cerr << \"Index not int range.\" << endl;" << endl
	  << "abort();" << endl
	  << "break;" << endl
	  << "}" << endl
	  << "}" << endl;
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_define_type_attribute_low() {
  IIR_Int32 indices = _get_num_indexes();
  IIR_TypeDefinition *node = this;

  _cc_out << "const ScalarType"  << endl;
  _publish_cc_type_name();
  _cc_out << "::LOW(const IntegerType& n) {" << endl
	  << "int val = ((UniversalInteger &) n.object->readVal()).val;" <<endl
	  << "switch(val) {" << endl;

  for(register IIR_Int32 i = 1; i <= indices; i++) {
    _cc_out << "case " << i << ":" << endl
	    << "  return ";
    if(node->_get_index_subtype()->_is_ascending_range() == TRUE) {
       if (node->_get_index_subtype()->_get_attribute()!=NULL){
	 if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	   node->_get_index_subtype()->get_left()->_publish_cc_type_name();      	   _cc_out << "(ObjectBase::VARIABLE, ";
	   ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_left();
      }
      if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	node->_get_index_subtype()->get_right()->_publish_cc_type_name();     
	_cc_out << "(ObjectBase::VARIABLE, ";
        ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_right();
      }
      _cc_out << ")";
       }
     else if(node->_get_index_subtype()->get_left()->_is_object() == TRUE) {
       node->_get_index_subtype()->get_left()->_publish_cc_type_name();      
       _cc_out << "(ObjectBase::VARIABLE, ";
       node->_get_index_subtype()->get_left()->_publish_cc();
       _cc_out << ")";
     }
     else {
	 node->_get_index_subtype()->get_left()->_publish_cc();
     }
    } 
    else {
      if (node->_get_index_subtype()->_get_attribute()!=NULL){
	if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	  node->_get_index_subtype()->get_left()->_publish_cc_type_name();    
	  _cc_out << "(ObjectBase::VARIABLE, ";
	  ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_right();
	}
	if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	  node->_get_index_subtype()->get_right()->_publish_cc_type_name();  
	  _cc_out << "(ObjectBase::VARIABLE, ";	  
	  ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_left();
	}
	_cc_out << ")";
      }
     else if(node->_get_index_subtype()->get_right()->_is_object() == TRUE) {
       node->_get_index_subtype()->get_right()->_publish_cc_type_name();      
       _cc_out << "(ObjectBase::VARIABLE, ";
       node->_get_index_subtype()->get_right()->_publish_cc();
       _cc_out << ")";
     }
      else {
	node->_get_index_subtype()->get_right()->_publish_cc();
      }
    } 
    _cc_out << ";" << endl
	    << "  break;" << endl;
    node = _get_element_subtype();
  }
  _cc_out << "default:" << endl
	  << "cerr << \"Index not int range.\" << endl;" << endl
	  << "abort();" << endl
	  << "break;" << endl
	  << "}" << endl
	  << "}" << endl;
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_define_type_attribute_high() {
  IIR_Int32 indices = _get_num_indexes();
  IIR_TypeDefinition *node = this;

  _cc_out << "const ScalarType"  << endl;
  _publish_cc_type_name();
  _cc_out << "::HIGH(const IntegerType& n) {" << endl
	  << "int val = ((UniversalInteger &) n.object->readVal()).val;" <<endl
	  << "switch(val) {" << endl;

  for(register IIR_Int32 i = 1; i <= indices; i++) {
    _cc_out << "case " << i << ":" << endl
	    << "  return ";
    if(node->_get_index_subtype()->_is_ascending_range() == TRUE) {
      if (node->_get_index_subtype()->_get_attribute()!=NULL){
	 if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	   node->_get_index_subtype()->get_left()->_publish_cc_type_name();  
	   _cc_out << "(ObjectBase::VARIABLE, ";
	   ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_right();
	 }
	 if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	   node->_get_index_subtype()->get_right()->_publish_cc_type_name(); 
	   _cc_out << "(ObjectBase::VARIABLE, ";
	   ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_left();
	 }
      _cc_out << ")";
      }
      else if(node->_get_index_subtype()->get_right()->_is_object() == TRUE) {
	node->_get_index_subtype()->get_right()->_publish_cc_type_name();      
	_cc_out << "(ObjectBase::VARIABLE, ";
	node->_get_index_subtype()->get_right()->_publish_cc();
	_cc_out << ")";
      }
      else {
	node->_get_index_subtype()->get_right()->_publish_cc();
      }
    } else {
      if (node->_get_index_subtype()->_get_attribute()!=NULL){
	 if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	   node->_get_index_subtype()->get_left()->_publish_cc_type_name();      	   _cc_out << "(ObjectBase::VARIABLE, ";
	   ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_left();
	 }
	 if (node->_get_index_subtype()->_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	   node->_get_index_subtype()->get_right()->_publish_cc_type_name();  
	   _cc_out << "(ObjectBase::VARIABLE, ";
	   ((IIRScram_Attribute*)node->_get_index_subtype()->_get_attribute())->_publish_cc_universal_right();
	 }
	 _cc_out << ")";
      } 
      else if(node->_get_index_subtype()->get_left()->_is_object() == TRUE) {
	  node->_get_index_subtype()->get_left()->_publish_cc_type_name();     
	  _cc_out << "(ObjectBase::VARIABLE, ";
	  node->_get_index_subtype()->get_left()->_publish_cc();
	  _cc_out << ")";
      }
      else {
	node->_get_index_subtype()->get_left()->_publish_cc();
      }
    } 
    _cc_out << ";" << endl
	    << "  break;" << endl;
    node = _get_element_subtype();
  }
  _cc_out << "default:" << endl
	  << "cerr << \"Index not int range.\" << endl;" << endl
	  << "abort();" << endl
	  << "break;" << endl
	  << "}" << endl
	  << "}" << endl;
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_define_type_attribute_length() {
  IIR_Int32 indices = _get_num_indexes();
  IIR_TypeDefinition *node = this;

  _cc_out << "const IntegerType"  << endl;
  _publish_cc_type_name();
  _cc_out << "::LENGTH(const IntegerType& n) {" << endl
	  << "int val = ((UniversalInteger &) n.object->readVal()).val;" <<endl
	  << "int retval;" << endl
	  << "switch(val) {" << endl;

  for(register IIR_Int32 i = 1; i <= indices; i++) {
    _cc_out << "case " << i << ":" << endl
	    << "  retval = abs(";
    node->_get_index_subtype()->get_left()->_publish_cc_value();
    _cc_out << " - ";
    node->_get_index_subtype()->get_right()->_publish_cc_value();
    _cc_out << ") + 1;" << endl
	    << "  return IntegerType(ObjectBase::VARIABLE, "
	    << "UniversalInteger(retval));" << endl
	    << "  break;" << endl;
    node = _get_element_subtype();
  }
  _cc_out << "default:" << endl
	  << "cerr << \"Index not int range.\" << endl;" << endl
	  << "abort();" << endl
	  << "break;" << endl
	  << "}" << endl
	  << "}" << endl;
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_define_type_attribute_ascending(){
  IIR_Int32 indices = _get_num_indexes();
  IIR_TypeDefinition *node = this;

  _cc_out << "const EnumerationType"  << endl;
  _publish_cc_type_name();
  _cc_out << "::ASCENDING(const EnumerationType& n) {" << endl
	  << "int val = ((UniversalInteger &) n.object->readVal()).val;" <<endl
	  << "switch(val) {" << endl;

  for(register IIR_Int32 i = 1; i <= indices; i++) {
    _cc_out << "case " << i << ":" << endl;
    if(node->_get_index_subtype()->_is_ascending_range() == TRUE) {
      _cc_out << "   return SAVANT_BOOLEAN_TRUE;" << endl;
    } else {
    _cc_out << "   return SAVANT_BOOLEAN_FALSE;" << endl;
    }
    _cc_out << "  break;" << endl;
    node = _get_element_subtype();
  }
  _cc_out << "default:" << endl
	  << "cerr << \"Index not int range.\" << endl;" << endl
	  << "abort();" << endl
	  << "break;" << endl
	  << "}" << endl
	  << "}" << endl;
}

// Subtype destructors.
void
IIRScram_ArraySubtypeDefinition::_publish_cc_decl_destructors() {
  if(_is_subtype_decl() == FALSE) {
    IIRScram_ArrayTypeDefinition::_publish_cc_decl_destructors();
  }
  else {
    // Publish the destructor
    _cc_out << "  virtual ~";
    _publish_cc_type_name();
    _cc_out << "() {" << endl
	  << "}" << endl
	    << endl;
  }
}

// Subtype constructors.
// ArrayTypeDefinition methods are used to publish the prototypes.
void
IIRScram_ArraySubtypeDefinition::_publish_cc_define_constructors() {
  //Though the subtype_indication may be a ARRAY Subtype, it may
  //be in  TYPE declaration. In that case the class for the 
  //corresponding type should have the appropriate functions
  //Hence the following check to see if it is a subtype declaration 
  // and doing accordingly
  if(_is_subtype_decl() == FALSE) {
    IIRScram_ArrayTypeDefinition::_publish_cc_constructor_with_no_value();
    IIRScram_ArrayTypeDefinition::_publish_cc_constructor_with_value();
    IIRScram_ArrayTypeDefinition::_publish_cc_copy_constructor();
    IIRScram_ArrayTypeDefinition::_publish_cc_constructor_with_aggregates();
    if(_get_num_indexes() == 1) {
      IIRScram_ArrayTypeDefinition::_publish_cc_constructor_for_alias_init();
    }
    else {
      IIRScram_ArrayTypeDefinition::_publish_cc_constructor_for_multidimension_alias_init();
    }
      
  if(_is_character_type() == TRUE) {
      IIRScram_ArrayTypeDefinition::_publish_cc_constructor_with_string();
    }
  }
  else {
    _publish_cc_constructor_with_no_value();
    _publish_cc_constructor_with_value();
    _publish_cc_copy_constructor();
    _publish_cc_constructor_with_aggregates();
    if(_get_num_indexes() == 1) {
      _publish_cc_constructor_for_alias_init();
    }
    else {
      _publish_cc_constructor_for_multidimension_alias_init();
    }
    if(_is_character_type() == TRUE) {
      _publish_cc_constructor_with_string();
    }

    _publish_cc_constructor_with_base_type();
  }
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_constructor_with_no_value() {
  _publish_cc_type_name();
  _cc_out << "::";
  _publish_cc_constructor_ranges();
  _cc_out << ", const TypeInfo& tInfo): ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType";
  if(_is_unconstrained_array_type() == TRUE) {
    _publish_cc_range_args();
  } else {
    if(get_base_type() != NULL) {
      if(get_base_type()->_is_unconstrained_array_type() == TRUE) {
	_cc_out << ", ";
	_publish_cc_range();
      }
    }
  }
  _cc_out << ", tInfo) {" << endl;
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl;

  //###Subtype declarations with unconstrained range not handled
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_constructor_with_value() {
  _publish_cc_type_name();
  _cc_out << "::";
  _publish_cc_type_name();
  _cc_out <<  "(ObjectBase::ObjectType objType, const ";
  _publish_cc_type_name();
  _cc_out << "& value): ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType ";
  if(get_base_type() != NULL) {
    if(get_base_type()->_is_unconstrained_array_type() == TRUE) {
      _cc_out << ", ";
      _publish_cc_range();
    }
  }
  _cc_out << ") {" << endl
	  << "   *object = *(value.object);" << endl;
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl << endl;
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_copy_constructor() {
  _publish_cc_type_name();
  _cc_out << "::";
  _publish_cc_type_name();
  _cc_out <<  "(const ";
  _publish_cc_type_name();
  _cc_out << "& value): ";
  _publish_cc_parent_type_name();
  _cc_out << "((const ";
  _publish_cc_parent_type_name();  
  _cc_out << " &) value) {}" << endl << endl;
}


void
IIRScram_ArraySubtypeDefinition::_publish_cc_constructor_with_string() {
  _publish_cc_type_name();
  _cc_out << "::";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, char* value"
	  << ", const TypeInfo& tInfo): ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType ";
  
  if(_is_unconstrained_array_type() == TRUE) {
    _publish_cc_range_args();
  } else {
    if(get_base_type() != NULL) {
      if(get_base_type()->_is_unconstrained_array_type() == TRUE) {
	_cc_out << ", ";
	_publish_cc_range();
      }
    }
  }
  
  _cc_out << ", value) {" << endl;
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl;
}


void
IIRScram_ArraySubtypeDefinition::_publish_cc_constructor_with_aggregates() {
  _publish_cc_type_name();
  _cc_out << "::";
  _publish_cc_type_name();
  _cc_out <<  "(ObjectBase::ObjectType objType, int noofElmntAssns, ... ) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType ";
  if(get_base_type() != NULL) {
    if(get_base_type()->_is_unconstrained_array_type() == TRUE) {
      _cc_out << ", ";
      _publish_cc_range();
    }
  }
  _cc_out << ") {\n";
  _publish_cc_constructor_aggregate_init();
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl << endl;
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_constructor_with_base_type() {
  _publish_cc_type_name();
  _cc_out << "::";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, const ";
  get_base_type()->_publish_cc_type_name();
  _cc_out << "& value) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType";
  if(_is_unconstrained_array_type() == TRUE) {
    _publish_cc_range_args();
  } else {
    if(get_base_type() != NULL) {
      if(get_base_type()->_is_unconstrained_array_type() == TRUE) {
	_cc_out << ", ";
	_publish_cc_range();
      }
    }
  }
  _cc_out << ", value) {" << endl;
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl;
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_constructor_for_multidimension_alias_init() {
  _publish_cc_type_name();
  _cc_out << "::";
  _publish_cc_type_name();
  _cc_out << "( bool alias, ObjectBase::ObjectType objectType, ";
  _cc_out << "ArrayType& actual) : ";
  _publish_cc_parent_type_name();
  _cc_out <<"(alias, objectType, actual)";
  _cc_out << " { }" << endl << endl;
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_constructor_for_alias_init() {
  _publish_cc_type_name();
  _cc_out << "::";
  _publish_cc_type_name();
  _cc_out << "( bool alias, ";
  _cc_out << "ObjectBase::ObjectType objType,";
  _cc_out << " int left, ArrayDirn_t dirn, int right, ";
  _cc_out << "const ArrayType& actual, const ArrayInfo& boundsOfActual) : ";
  _publish_cc_parent_type_name();
  _cc_out <<"(alias, objType, left, dirn, right, actual, boundsOfActual)";
  _cc_out << " { }" << endl << endl;
}

// End of subtype constructors.

void
IIRScram_ArraySubtypeDefinition::_publish_cc_decl_class_event_destructor() {
  if(_is_subtype_decl() == FALSE) {
    IIRScram_ArrayTypeDefinition::_publish_cc_decl_class_event_destructor();
  }
  else {
    _cc_out << "  virtual ~";
    _publish_cc();
    _cc_out << "_event()  {}" << endl << endl;
  }
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_decl_class_event_constructor() {
  if(_is_subtype_decl() == FALSE) {
    IIRScram_ArrayTypeDefinition::_publish_cc_class_event_constructor_with_no_value();
    IIRScram_ArrayTypeDefinition::_publish_cc_class_event_constructor_with_aggregates();
  }
  else {  
    _publish_cc_class_event_constructor_with_no_value();
    _publish_cc_class_event_constructor_with_aggregates();
  }
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_class_event_constructor_with_no_value() {

  // Constructor needed for vector initializations
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "_event() : ";
  _publish_cc_parent_type_name();
  _cc_out << "_event()  {}\n";

  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out <<  "_event(ObjectBase::ObjectType objType";
  if(_is_unconstrained_array_type() == TRUE) {
    IIR_Int32 dimensions = _get_num_indexes();
    IIR_TypeDefinition *node = this;
    for(register IIR_Int32 i= 0; i < dimensions; i++) {
      _cc_out << ", "
	      << "left" << i << ", "
	      << "dirn" << i << ", "
	      << "right" << i;
      node = node->_get_element_subtype();
    }
  }
  else {
    _cc_out << ", const TypeInfo& = TypeInfo::NULL_TYPE_INFO";
  }
  
  _cc_out << "): ";
  _publish_cc_parent_type_name();
  _cc_out << "_event(objType";
  if(_is_unconstrained_array_type() == TRUE) {
    _cc_out << ", ";
    IIR_Int32 dimensions = _get_num_indexes();
    IIR_TypeDefinition *node = this;
    for(register IIR_Int32 i= 0; i < dimensions; i++) {
      _cc_out << "left" << i << ", "
	      << "dirn" << i << ", "
	      << "right" << i;
      node = node->_get_element_subtype();
    }
  } else {
    if(get_base_type()->_is_unconstrained_array_type() == TRUE) {
      _cc_out << ", ";
      _publish_cc_range();
    }
  }
  _cc_out << ") {\n";
  _cc_out << "}\n";
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_class_event_constructor_with_aggregates() {
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out <<  "_event(ObjectBase::ObjectType objType, int noofElmntAssns, ... ) : ";
  _publish_cc_parent_type_name();
  _cc_out << "_event(objType";
  if(get_base_type()->_is_unconstrained_array_type() == TRUE) {
    _cc_out << ", ";
    _publish_cc_range();
  }
  _cc_out << ") {\n";
  _publish_cc_constructor_aggregate_init();
  _cc_out << "}\n";
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_decl_class_last_event_destructor() {
  if(_is_subtype_decl() == FALSE) {
    IIRScram_ArrayTypeDefinition::_publish_cc_decl_class_last_event_destructor();
  }
  else {
    _cc_out << "  virtual ~";
    _publish_cc();
    _cc_out << "_lastevent()  {\n";
    _cc_out << "}\n";
  }
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_decl_class_last_event_constructor() {
  if(_is_subtype_decl() == FALSE) {
    IIRScram_ArrayTypeDefinition::_publish_cc_class_last_event_constructor_with_no_value();
    IIRScram_ArrayTypeDefinition::_publish_cc_class_last_event_constructor_with_aggregates();
  }
  else {
    _publish_cc_class_last_event_constructor_with_no_value();
    _publish_cc_class_last_event_constructor_with_aggregates();
  }
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_class_last_event_constructor_with_no_value() {
  
  _cc_out << " ";
  _publish_cc_type_name();
  _cc_out << "_lastevent() : ";
  _publish_cc_parent_type_name();
  _cc_out << "_lastevent()  {}\n" << endl;
  
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out <<  "_lastevent(ObjectBase::ObjectType objType";
  if(_is_unconstrained_array_type() == TRUE) {
    IIR_Int32 dimensions = _get_num_indexes();
    IIR_TypeDefinition *node = this;
    for(register IIR_Int32 i= 0; i < dimensions; i++) {
      _cc_out << ", "
	      << "left" << i << ", "
	      << "dirn" << i << ", "
	      << "right" << i;
      node = node->_get_element_subtype();
    }
  }
  else {
    _cc_out << ", const TypeInfo& tInfo = TypeInfo::NULL_TYPE_INFO";
  }
  
  _cc_out << "): ";
  _publish_cc_parent_type_name();
  _cc_out << "_lastevent(objType";
  if(_is_unconstrained_array_type() == TRUE) {
    _cc_out << ", ";
    IIR_Int32 dimensions = _get_num_indexes();
    IIR_TypeDefinition *node = this;
    for(register IIR_Int32 i= 0; i < dimensions; i++) {
      _cc_out << "left" << i << ", "
	      << "dirn" << i << ", "
	      << "right" << i;
      node = node->_get_element_subtype();
    }
  } else {
    if(get_base_type()->_is_unconstrained_array_type() == TRUE) {
      _cc_out << ", ";
      _publish_cc_range();
    }
  }
  _cc_out << ") {\n";
  _cc_out << "}\n";
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_class_last_event_constructor_with_aggregates() {
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out <<  "_lastevent(ObjectBase::ObjectType objType, int noofElmntAssns, ... ) : ";
  _publish_cc_parent_type_name();
  _cc_out << "_lastevent(objType";
  if(get_base_type()->_is_unconstrained_array_type() == TRUE) {
    _cc_out << ", ";
    _publish_cc_range();
  }
  _cc_out << ") {\n";
  _publish_cc_constructor_aggregate_init();
  _cc_out << "}\n";
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_extern_type_info(){
  IIRScram_ArrayTypeDefinition::_publish_cc_extern_type_info();
}

void
IIRScram_ArraySubtypeDefinition::_publish_cc_type_info(){
  IIRScram_ArrayTypeDefinition::_publish_cc_type_info();
}

IIR *
IIRScram_ArraySubtypeDefinition::_clone(){
  IIR_ArraySubtypeDefinition *my_clone = new IIR_ArraySubtypeDefinition();
  IIRScram::_clone( my_clone );

  my_clone->set_resolution_function( get_resolution_function() );

  IIR_ArrayTypeDefinition::_clone( my_clone );

  return my_clone;
}

IIR_Boolean 
IIRScram_ArraySubtypeDefinition::_is_locally_static(){
  IIR_Boolean retval = TRUE;

  if( _is_unconstrained_array_type() == TRUE ){
    retval = FALSE;
  }
  else{
    IIR_ScalarTypeDefinition *current_index = get_index_subtype();
    if( current_index->_is_locally_static() == FALSE ){
      retval = FALSE;
    }
    IIR_TypeDefinition *current_element_type = get_element_subtype();
    ASSERT( current_element_type != NULL );
    while( current_element_type->_is_iir_array_type_definition() == TRUE && 
	   current_element_type->_is_element() == FALSE ){
      IIR_ArrayTypeDefinition *as_array_type = (IIR_ArrayTypeDefinition *)current_element_type;
      ASSERT( as_array_type->get_index_subtype() != NULL );
      if( as_array_type->get_index_subtype()->_is_locally_static() == FALSE ){
	retval = FALSE;
	break;
      }
      current_element_type = as_array_type->get_element_subtype();
      ASSERT( current_element_type != NULL );
    }
  }

  return retval;
}


IIR_Boolean 
IIRScram_ArraySubtypeDefinition::_is_globally_static(){
  IIR_Boolean retval = TRUE;

  if( _is_unconstrained_array_type() == TRUE ){
    retval = FALSE;
  }
  else{
    IIR_ScalarTypeDefinition *current_index = get_index_subtype();
    if( current_index->_is_globally_static() == FALSE ){
      retval = FALSE;
    }
    IIR_TypeDefinition *current_element_type = get_element_subtype();
    ASSERT( current_element_type != NULL );
    while( current_element_type->_is_iir_array_type_definition() == TRUE && 
	   current_element_type->_is_element() == FALSE ){
      IIR_ArrayTypeDefinition *as_array_type = (IIR_ArrayTypeDefinition *)current_element_type;
      ASSERT( as_array_type->get_index_subtype() != NULL );
      if( as_array_type->get_index_subtype()->_is_globally_static() == FALSE ){
	retval = FALSE;
	break;
      }
      current_element_type = as_array_type->get_element_subtype();
      ASSERT( current_element_type != NULL );
    }
  }

  return retval;
}
