
#ifndef IIRBASE_PORT_LIST_HH
#define IIRBASE_PORT_LIST_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_PortList.hh,v 1.2 1999/03/09 20:51:21 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_InterfaceList.hh"

class IIR_SignalInterfaceDeclaration;

class IIRBase_PortList : public IIR_InterfaceList {

public:
  IIR_Kind get_kind() { return IIR_PORT_LIST; }
  IIR_Char *get_kind_text() { return "IIR_PortList"; }

  void prepend( IIR_SignalInterfaceDeclaration * );
  void append( IIR_SignalInterfaceDeclaration * );

  void insert_after( IIR_SignalInterfaceDeclaration *,
				    IIR_SignalInterfaceDeclaration * );

  IIR_Boolean insert_before_element( IIR_SignalInterfaceDeclaration *,
				     IIR_SignalInterfaceDeclaration * );

  void remove( IIR_SignalInterfaceDeclaration * );
  IIR_SignalInterfaceDeclaration *successor( IIR_SignalInterfaceDeclaration * );
  IIR_SignalInterfaceDeclaration *predecessor( IIR_SignalInterfaceDeclaration * );
  IIR_SignalInterfaceDeclaration *first( );
  IIR_SignalInterfaceDeclaration *last();
  IIR_Int32 get_position( IIR_SignalInterfaceDeclaration * );

protected:
  IIRBase_PortList();
  virtual ~IIRBase_PortList() = 0;
    
private:

};
#endif
