/*$Id: d_trln.h,v 15.18 1999/10/30 08:04:59 al Exp $ -*- C++ -*-
 * structures, etc. for transmission lines
 */
#ifndef D_TRNLIN_H
#define D_TRNLIN_H
#include "l_inttbl.h" // for PAIR
#include "l_denoise.h"
#include "e_elemnt.h"
/*--------------------------------------------------------------------------*/
enum {NUM_INIT_COND = 4};
/*--------------------------------------------------------------------------*/
class WAVE {
private:
  std::deque<PAIR<double,double> > _w;
  double _delay;
  explicit WAVE(const WAVE&);
public:
  explicit WAVE(double d=0) 
		: _w(), _delay(d) {initialize();}
  WAVE&	   set_delay(double d) 
		{_delay = d; initialize(); return *this;}
  WAVE&    initialize()
		{_w.clear(); push(0-_delay, 0.); push(0., 0.); return *this;}
  void	   push(double t, double v)
		{_w.push_back(PAIR<double,double>(t+_delay, v));}
  double   v_out(double t)const
		{FPOLY1 rv = interpolate(_w.begin(),_w.end(),t); return rv.f0;}
  double   v_reflect(double t, double v_total)const
		{return dn_diff(v_total*2, v_out(t));}
};
/*--------------------------------------------------------------------------*/
class TRANSLINE_COMMON : public COMPONENT_COMMON {
public:
  explicit TRANSLINE_COMMON(int c=0);
  explicit TRANSLINE_COMMON(const TRANSLINE_COMMON& p);
  const char* name()const	{untested(); return "transline";}
  double   z0;			/* characteristic impedance */
  double   td;			/* delay time */
  double   f;			/* specification frequency */
  double   nl;			/* length (wavelengths) at f */
  double   ic[NUM_INIT_COND];	/* initial conditions: v1, i1, v2, i2 */
  int	   icset;		/* flag: initial condition set */
};
/*--------------------------------------------------------------------------*/
class DEV_TRANSLINE : public ELEMENT {
private:
  WAVE	 _forward;
  WAVE	 _reflect;
  double _if0; // value of current source representing incident wave
  double _ir0; // value of current source representing reflected wave
  double _if1; // val of cs rep incident wave, one load ago
  double _ir1; // val of cs rep reflected wave, one load ago
private:
  explicit	DEV_TRANSLINE(const DEV_TRANSLINE& p)
    :ELEMENT(p), _forward(), _reflect(), _if0(0), _ir0(0), _if1(0), _ir1(0)
    {untested();}
public:
  explicit	DEV_TRANSLINE();
private: // override virtual
  const char*	dev_type()const		{untested(); return "tline";}
  CARD*		clone()const	{untested();return new DEV_TRANSLINE(*this);}
  void		parse(CS&);
  void		print(OMSTREAM,int)const;
  //void	expand();		//CARD/nothing
  void		precalc();

  void		dc_begin()		{untested();}
  void		tr_begin();
  //void	tr_restore();		//CARD/nothing
  void		dc_advance()		{tr_advance();}
  void		tr_advance();
  bool		tr_needs_eval()	{return (_if0 != _if1  ||  _ir0 != _ir1);}
  void		tr_queue_eval()	{if(tr_needs_eval()){q_eval();}}
  bool		do_tr();
  void		tr_load();
  double	tr_review();
  void		tr_accept();
  void		tr_unload();
  double	tr_involts()const
			{return dn_diff(n[IN1].v0(), n[IN2].v0());}

  //void	ac_begin();		//CARD/nothing
  void		do_ac();
  COMPLEX	ac_involts()const 
			{untested(); return n[IN1].vac() - n[IN2].vac();}

  int		numnodes()const		{return 4;}
  bool		is_2port()const		{untested(); return true;}
private:
  void		setinitcond(CS&);
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
