/*$Id: d_mosc.cc,v 15.17 1999/10/27 09:15:51 al Exp $ -*- C++ -*-
 * mos model subcircuit functions
 */
#include "d_mos123.h"
/*--------------------------------------------------------------------------*/
//	void	EVAL_MOS_Ids::tr_eval(COMPONENT*)const;
//	void	EVAL_MOS_Gmf::tr_eval(COMPONENT*)const;
//	void	EVAL_MOS_Gmr::tr_eval(COMPONENT*)const;
//	void	EVAL_MOS_Gds::tr_eval(COMPONENT*)const;
//	void	EVAL_MOS_Gmbf::tr_eval(COMPONENT*)const;
//	void	EVAL_MOS_Gmbr::tr_eval(COMPONENT*)const;
//	void	EVAL_MOS_Cgb::tr_eval(COMPONENT*)const;
//	void	EVAL_MOS_Cgd::tr_eval(COMPONENT*)const;
//	void	EVAL_MOS_Cgs::tr_eval(COMPONENT*)const;
/*--------------------------------------------------------------------------*/
/* mos2_ids: drain-source current calculations
 * returns ids
 */
void EVAL_MOS_Ids::tr_eval(COMPONENT *brh)const
{
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  const MOS_COMMON* c = prechecked_cast<const MOS_COMMON*>(p->common());
  assert(c);
  const MODEL_MOS_BASE* m = prechecked_cast<const MODEL_MOS_BASE*>(c->model());
  assert(m);
  brh->y0.f1 = m->polarity * ((p->reversed) ? -p->ids : p->ids);
  brh->y0.f0 = 0.;
  trace3(brh->long_label(), brh->y0.x, brh->y0.f0, brh->y0.f1);
}
/*--------------------------------------------------------------------------*/
/* mos2_gmf: gate transconductance calculations forward mode
 * returns gm or 0
 */
void EVAL_MOS_Gmf::tr_eval(COMPONENT *brh)const
{
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  brh->y0.f1 = (p->reversed) ? 0. : p->gm;
  brh->y0.f0 = 0.;
  trace3(brh->long_label(), brh->y0.x, brh->y0.f0, brh->y0.f1);
}
/*--------------------------------------------------------------------------*/
/* mos2_gmr: gate transconductance calculations reversed mode
 * returns gm or 0
 */
void EVAL_MOS_Gmr::tr_eval(COMPONENT *brh)const
{
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  brh->y0.f1 = (p->reversed) ? p->gm : 0.;
  brh->y0.f0 = 0.;
  trace3(brh->long_label(), brh->y0.x, brh->y0.f0, brh->y0.f1);
}
/*--------------------------------------------------------------------------*/
/* mos2_gds: self-conductance calculations
 * returns gds
 */
void EVAL_MOS_Gds::tr_eval(COMPONENT *brh)const
{
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  brh->y0.f1 = p->gds;
  brh->y0.f0 = 0.;
  trace3(brh->long_label(), brh->y0.x, brh->y0.f0, brh->y0.f1);
}
/*--------------------------------------------------------------------------*/
/* mos2_gmbf: bulk transconductance calculations, forward mode
 * returns gmb or 0
 */
void EVAL_MOS_Gmbf::tr_eval(COMPONENT *brh)const
{
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  brh->y0.f1 = (p->reversed) ? 0. : p->gmb;
  brh->y0.f0 = 0.;
  trace3(brh->long_label(), brh->y0.x, brh->y0.f0, brh->y0.f1);
}
/*--------------------------------------------------------------------------*/
/* mos2_gmbr: bulk transconductance calculations, reversed mode
 * returns gmb or 0
 */
void EVAL_MOS_Gmbr::tr_eval(COMPONENT *brh)const
{
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  brh->y0.f1 = (p->reversed) ? p->gmb : 0.;
  brh->y0.f0 = 0.;
  trace3(brh->long_label(), brh->y0.x, brh->y0.f0, brh->y0.f1);
}
/*--------------------------------------------------------------------------*/
/* gate capacitors.  Meyer model.  
 * Refs: Antognetti, Divekar, Spice 2 & 3 code
 * final ref was Spice 2g6 code.
 * all except spice 3 agree except for typos and smoothing.  (yup!!)
 * (smoothing is different)
 * Spice 3 ignores substrate voltage, and returns half the value of Cgs
 */
void EVAL_MOS_Cgb::tr_eval(COMPONENT *brh)const
{
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  const MOS_COMMON* c = prechecked_cast<const MOS_COMMON*>(p->common());
  assert(c);
  const MODEL_MOS123* m = prechecked_cast<const MODEL_MOS123*>(c->model());
  assert(m);

  double cap = brh->value();
  if (p->vgst < - m->phi){ 			/* accumulation */
    cap += c->cgate;
  }else if (p->vgst < 0.){			/* depletion */
    cap += c->cgate * (-p->vgst) / m->phi;
  }else{					/* active, overlap only */
  }
  brh->y0.f1 = cap;
  brh->y0.f0 = brh->y0.x * brh->y0.f1;
  trace3(brh->long_label(), brh->y0.x, brh->y0.f0, brh->y0.f1);
}
/*--------------------------------------------------------------------------*/
void EVAL_MOS_Cgd::tr_eval(COMPONENT *brh)const
{
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  const MOS_COMMON* c = prechecked_cast<const MOS_COMMON*>(p->common());
  assert(c);
  const MODEL_MOS123* m = prechecked_cast<const MODEL_MOS123*>(c->model());
  assert(m);

  double mult;
  double vbs;
  if (m->cmodel == 3){
    mult = 1./3.;
    vbs = 0.;
  }else{
    mult = 2./3.;
    vbs = p->vbs;
  }
  double cap = brh->value();			/* start with overlap cap */
  if (p->vgst > 0.  &&  p->vdsat > p->vds){	/* linear */
    double vdbsat = p->vdsat - vbs;
    double vdb    = p->vds   - vbs;
    double ddif   = 2. * vdbsat - vdb;
    cap += mult * c->cgate * (1. - (vdbsat*vdbsat)/(ddif*ddif));
  }						/* else overlap only */
  brh->y0.f1 = cap;
  brh->y0.f0 = brh->y0.x * brh->y0.f1;
  trace3(brh->long_label(), brh->y0.x, brh->y0.f0, brh->y0.f1);
}
/*--------------------------------------------------------------------------*/
void EVAL_MOS_Cgs::tr_eval(COMPONENT *brh)const
{
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  const MOS_COMMON* c = prechecked_cast<const MOS_COMMON*>(p->common());
  assert(c);
  const MODEL_MOS123* m = prechecked_cast<const MODEL_MOS123*>(c->model());
  assert(m);

  double mult;
  double vbs;
  if (m->cmodel == 3){
    mult = 1./3.;
    vbs = 0.;
  }else{
    mult = 2./3.;
    vbs = p->vbs;
  }
  double cap = brh->value();			/* start with overlap cap */
  if (p->vgst > 0.){				/* active */
    if (p->vdsat > p->vds){			/* linear */
      double vdbsat = p->vdsat - vbs;
      double vdb    = p->vds   - vbs;
      double ddif   = 2. * vdbsat - vdb;
      double ndif   = p->vdsat - p->vds;
      cap += mult * c->cgate * (1. - (ndif*ndif)/(ddif*ddif));
    }else{					/* saturation */
      cap += mult * c->cgate;
    }
  }else if (p->vgst > -m->phi/2.){		/* depletion */
    cap += mult * c->cgate * ((p->vgst / (m->phi/2.)) + 1.);
  }else{					/* accum. = overlap only */
  }
  brh->y0.f1 = cap;
  brh->y0.f0 = brh->y0.x * brh->y0.f1;
  trace3(brh->long_label(), brh->y0.x, brh->y0.f0, brh->y0.f1);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
