/*$Id: bm_poly.cc,v 15.14 1999/10/20 08:53:59 al Exp $ -*- C++ -*-
 * HSPICE compatible POLY
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
//		EVAL_BM_POLY::EVAL_BM_POLY(int c);
//		EVAL_BM_POLY::EVAL_BM_POLY(const EVAL_BM_POLY& p);
//	void	EVAL_BM_POLY::parse(CS& cmd);
// 	void	EVAL_BM_POLY::print(int)const;
//	void	EVAL_BM_POLY::tr_eval(COMPONENT* d)const;
/*--------------------------------------------------------------------------*/
const double _default_max(BIGBIG);
const double _default_min(-BIGBIG);
const bool   _default_abs(false);
/*--------------------------------------------------------------------------*/
EVAL_BM_POLY::EVAL_BM_POLY(int c)
  :EVAL_BM_ACTION_BASE(c),
   _max(_default_max),
   _min(_default_min),
   _abs(_default_abs)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_POLY::EVAL_BM_POLY(const EVAL_BM_POLY& p)
  :EVAL_BM_ACTION_BASE(p),
   _max(p._max),
   _min(p._min),
   _abs(p._abs),
   _c(p._c)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_POLY::parse(CS& cmd)
{
  cmd.stuck();
  do{
    int paren = cmd.skiplparen();
    for (;;){
      double value=NOT_VALID;
      cmd >> value;
      if (cmd.stuck()){
	break;
      }
      _c.push_back(value);
    }
    paren -= cmd.skiprparen();
    if (paren != 0){
      cmd.warn(bWARNING, "need )");
    }
    cmd.get("MIn", &_min);
    cmd.get("MAx", &_max);
    cmd.get("Abs", &_abs);
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck());
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_POLY::print(OMSTREAM where)const
{
  where << "  " << name() << '(';
  for (std::vector<double>::const_iterator
	 p = _c.begin();  p != _c.end();  ++p){
    where << "  " << *p;
  }
  where << ')';
  print_base(where);
  if (_min != _default_min) {where << "  min=" << _min;}
  if (_max != _default_max) {where << "  max=" << _max;}
  if (_abs != _default_abs) {where << "  abs=" << _abs;}
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_POLY::tr_eval(COMPONENT* d)const
{
  double x = ioffset(d->y0.x);
  double f0 = 0.;
  double f1 = 0.;
  for (int i=_c.size()-1; i>0; --i){
    f0 += _c[i];
    f0 *= x;
    f1 *= x;
    f1 += _c[i]*i;
  }
  f0 += _c[0];

  if (_abs && f0 < 0){
    f0 = -f0;
    f1 = -f1;
  }

  {if (f0 > _max){
    f0 = _max;
    f1 = 0;
  }else if (f0 < _min){
    f0 = _min;
    f1 = 0;
  }}

  d->y0 = FPOLY1(x, f0, f1);
  tr_final_adjust(&(d->y0));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
