/************************************************************************/
/*  Describes a BMP file.						*/
/************************************************************************/

#ifndef BMMSBMP_H
#define BMMSBMP_H   1

#define COMPRESS_RGB        0L      /* No compression               */
#define COMPRESS_RLE8       1L      /* 8 bits per pixel compression */
#define COMPRESS_RLE4       2L      /* 4 bits per pixel compression */
#define BMP_ID              0x4d42  /* BMP "magic" number           */

/************************************************************************/
/*  Common information for all kinds of BMP files.			*/
/************************************************************************/
typedef struct BmpFileHeader
    {
			/************************************************/
			/*  Common to all variants.			*/
			/************************************************/
    short	bfhMagic;
    long	bfhFileSize;
    short	bfhReserved1;
    short	bfhReserved2;
    long	bfhBitmapDataOffset;
    long	bfhSizeOfRestOfHeader;	/*  It is the Type of file!	*/
			/************************************************/
			/*  Common to all variants.			*/
			/************************************************/
    long	bfhPixelsWide;
    long	bfhPixelsHigh;
    short	bfhPlanes;
    short	bfhBitsPerPixel;
			/************************************************/
			/*  Common to Windows 3.* and OS/2 2.*		*/
			/************************************************/
    long	bfhCompression;
    long	bfhBufferLength;
    long	bfhXResolution;
    long	bfhYResolution;
    long	bfhColorCount;
    long	bfhImportantColors;
    } BmpFileHeader;

extern int bmpHeaderToDescription(	BitmapDescription *	bd,
					int *			pBytesPerRow,
					int *			pPrivateFormat,
					const BmpFileHeader *	bfh,
					int			assumeAlpha );
#   endif
