/************************************************************************/
/*									*/
/*  Operating system related functionality.				*/
/*									*/
/************************************************************************/

typedef int (*FILE_CALLBACK)	(		const char *	name,
						void *		through );

/************************************************************************/
/*									*/
/*  Operating system related functionality.. Declarations.		*/
/*									*/
/************************************************************************/

extern int appHomeDirectory(	char *		home,
				int		len );

extern int appTestDirectory(	const char *	dir );
extern int appTestFileWritable( const char *	file );
extern int appTestFileExists( const char *	file );
extern int appTestFileReadable( const char *	file );

extern int appMakeDirectory(	const char *	dir );

extern long appGetTimestamp( void );

extern int appAbsoluteName(	char *		absolute,
				int		len,
				const char *	filename );

extern int appRemoveFile(	const char *	filename );

extern int appForAllFiles(	const char *		dir,
				const char *		ext,
				void *			through,
				FILE_CALLBACK		callback );
