#   include	<stdio.h>
#   include	<appGeo.h>
#   include	<docFont.h>
#   include	<psFont.h>

/************************************************************************/
/*									*/
/*  The state of a printing job.					*/
/*									*/
/************************************************************************/

typedef struct PrintingState
    {
    FILE *			psFile;

    int				psCurrentPhysicalFont;
    int				psCurrentPage;
    int				psPrinterWideTwips;
    int				psPrinterHighTwips;
    const char *		psAfmDirectory;
    void *			psPhysicalFontList;

    int				psInLink;
    int				psLinkParticulesDone;
    int				psLinkRectLeft;

    const char *		psLinkFile;
    int				psLinkFileSize;
    const char *		psLinkMark;
    int				psLinkMarkSize;
    } PrintingState;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void appPsBoundingBoxComment(  FILE *		f,
			    const DocumentGeometry *	dg,
			    int				paperWideTwips,
			    int				paperHighTwips,
			    const char *		comment,
			    const char *		orientationComment );

extern void appPsPrintString(	FILE *			f,
				const unsigned char *	s,
				int			len );

extern void appPsSetFont(	FILE *		f,
				TextAttribute	ta );

extern int appPsRememberAfi(	AfmFontInfo *		afi,
				TextAttribute		ta,
				PostScriptFont **	pFontList,
				int *			pCount );

extern void appPsInitPrintingState(	PrintingState *	ps );

extern void appPsSetLinkColor( const PrintingState *   ps );

extern void appPsStartPage(	const PrintingState *		ps,
				const DocumentGeometry *	dg );

extern void appPsFinishPage(	FILE *		f,
				int		pageNumber );
