/************************************************************************/
/*									*/
/*  Print Postscript.							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	<appPs.h>

#   include	<debugon.h>

/************************************************************************/
/*									*/
/*  Print a bounding box.						*/
/*									*/
/************************************************************************/
void appPsBoundingBoxComment(  FILE *		f,
			    const DocumentGeometry *	dg,
			    int				printerWideTwips,
			    int				printerHighTwips,
			    const char *		comment,
			    const char *		orientationComment )
    {
    double	yshift= 0.0;

    if  ( dg->dgPaperHighTwips >= dg->dgPaperWideTwips )
	{
	if  ( dg->dgPaperHighTwips < printerHighTwips )
	    { yshift= ( printerHighTwips- dg->dgPaperHighTwips )/20; }

	fprintf( f, "%%%%%s: %g %g %g %g\n",
		comment,
		dg->dgLeftMarginTwips/20.0,
		dg->dgBottomMarginTwips/20.0+ yshift,
		(dg->dgPaperWideTwips- dg->dgRightMarginTwips)/20.0,
		(dg->dgPaperHighTwips- dg->dgTopMarginTwips)/20.0+ yshift );

	fprintf( f, "%%%%%s: Portrait\n", orientationComment );
	}
    else{
	if  ( dg->dgPaperWideTwips < printerHighTwips )
	    { yshift= ( printerHighTwips- dg->dgPaperWideTwips )/20; }

	fprintf( f, "%%%%%s: %g %g %g %g\n",
		comment,
		dg->dgTopMarginTwips/20.0,
		dg->dgLeftMarginTwips/20.0+ yshift,
		(dg->dgPaperHighTwips- dg->dgBottomMarginTwips)/20.0,
		(dg->dgPaperWideTwips- dg->dgRightMarginTwips)/20.0+ yshift );

	fprintf( f, "%%%%%s: Landscape\n", orientationComment );
	}
    }

/************************************************************************/
/*									*/
/*  Issue a character string.						*/
/*									*/
/************************************************************************/

void appPsPrintString(	FILE *			f,
			const unsigned char *	s,
			int			len )
    {
    int		i;

    for ( i= 0; i < len; s++, i++ )
	{
	if  ( *s == '(' || *s == ')' || *s == '\\' )
	    { putc( '\\', f ); }
	putc( *s, f );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Set the font, this depends on the assumption that fonts have been	*/
/*  defined for the different fonts in the document.			*/
/*									*/
/************************************************************************/

void appPsSetFont(	FILE *		f,
			TextAttribute	ta )
    {
    int		fontSizeTwips= 10* ta.taFontSizeHalfPoints;

    if  ( ta.taSuperSub == DOCfontSUPERSCRIPT	||
	  ta.taSuperSub == DOCfontSUBSCRIPT	)
	{ fontSizeTwips= ( 6* fontSizeTwips )/ 10; }

    fprintf( f, "[ %d 0 0 %d 0 0 ] f%d",
		fontSizeTwips, -fontSizeTwips, ta.taFontNumber );

    if  ( ta.taFontIsBold )
	{ putc( 'b', f );	}
    if  ( ta.taFontIsSlanted )
	{ putc( 'i', f );	}
    putc( '\n', f );

    return;
    }


/************************************************************************/
/*									*/
/*  Collect the fonts in a document					*/
/*  This has two functions:						*/
/*	1)  They are needed for the DSC comments.			*/
/*	2)  This makes it possible to define shorthands in the prologue	*/
/*									*/
/************************************************************************/

int appPsRememberAfi(	AfmFontInfo *		afi,
			TextAttribute		ta,
			PostScriptFont **	pFontList,
			int *			pCount )
    {
    int			i;
    PostScriptFont *	psf= *pFontList;

    for ( i= 0; i < *pCount; psf++, i++ )
	{
	if  ( psf->psfAttributes.taFontNumber == ta.taFontNumber	&&
	      psf->psfAttributes.taFontIsBold == ta.taFontIsBold	&&
	      psf->psfAttributes.taFontIsSlanted == ta.taFontIsSlanted	)
	    { break;	}
	}

    if  ( i >= *pCount )
	{
	char *			s;

	psf= (PostScriptFont *)
		    realloc( *pFontList, (i+ 1)* sizeof(PostScriptFont) );
	if  ( ! psf )
	    { LXDEB(i,psf); return -1;	}
	*pFontList= psf;
	*pCount= i+ 1;

	(*pFontList)[i].psfAfi= afi;
	(*pFontList)[i].psfAttributes= ta;

	s= (*pFontList)[i].psfFontId;
	sprintf( s, "f%d", ta.taFontNumber );
	if  ( ta.taFontIsBold )
	    { s += strlen( s ); s[0]= 'b'; s[1]= '\0'; s++; }
	if  ( ta.taFontIsSlanted )
	    { s += strlen( s ); s[0]= 'i'; s[1]= '\0'; s++; }
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Initialise a printing session.					*/
/*									*/
/************************************************************************/

void appPsInitPrintingState(	PrintingState *	ps )
    {
    ps->psFile= (FILE *)0;
    ps->psCurrentPhysicalFont= -1;
    ps->psCurrentPage= 0;

    ps->psPrinterWideTwips= 0;
    ps->psPrinterHighTwips= 0;

    ps->psAfmDirectory= (const char *)0;
    ps->psPhysicalFontList= (void *)0;

    ps->psInLink= 0;
    ps->psLinkParticulesDone= 0;
    ps->psLinkRectLeft= -1;
    ps->psLinkFile= (const char *)0;
    ps->psLinkFileSize= 0;
    ps->psLinkMark= (const char *)0;
    ps->psLinkMarkSize= 0;

    return;
    }

/************************************************************************/
/*									*/
/*  Switch to the 'Link Color'						*/
/*									*/
/************************************************************************/

void appPsSetLinkColor(	const PrintingState *	ps )
    {
    fprintf( ps->psFile, "/DeviceRGB setcolorspace 0.0 0.0 0.8 setcolor\n" );
    }

/************************************************************************/
/*									*/
/*  Go to the next page.						*/
/*									*/
/************************************************************************/

void appPsStartPage(	const PrintingState *		ps,
			const DocumentGeometry *	dg )
    {
    fprintf( ps->psFile, "%%%%Page: %d %d\n",
			    ps->psCurrentPage+ 1, ps->psCurrentPage+ 1 );

    appPsBoundingBoxComment( ps->psFile, dg,
			    ps->psPrinterWideTwips, ps->psPrinterHighTwips,
			    "PageBoundingBox", "PageOrientation" );

    fprintf( ps->psFile, "%%%%BeginPageSetup\n" );
    fprintf( ps->psFile, "gsave\n" );

    if  ( dg->dgPaperHighTwips >= dg->dgPaperWideTwips )
	{
	fprintf( ps->psFile, "[ 0.05 0 0 -0.05 0 %g ] concat\n",
					    ps->psPrinterHighTwips/20.0 );
	}
    else{
	double		yshift= 0.0;

	if  ( dg->dgPaperWideTwips < ps->psPrinterHighTwips )
	    { yshift= ps->psPrinterHighTwips- dg->dgPaperWideTwips; }

	fprintf( ps->psFile, "[ 0 0.05 0.05 0 0 %g ] concat\n",
					    yshift/ 20.0 );
	}

    if  ( ps->psInLink )
	{ appPsSetLinkColor( ps );		}
    else{ fprintf( ps->psFile, "0 setgray\n" );	}

    fprintf( ps->psFile, "%%%%EndPageSetup\n" );
    }

void appPsFinishPage(	FILE *		f,
			int		pageNumber )
    {
    fprintf( f, "showpage %% page %d\n", pageNumber+ 1 );
    fprintf( f, "%%%%PageTrailer\n" );
    }
