#   include	"config.h"
#   include	"appGeo.h"

void docInitRectangle(	DocumentRectangle *		dr )
    { dr->drX0= dr->drY0= dr->drX1= dr->drY1= 0; return; }

void docUnionRectangle(	DocumentRectangle *		dr,
			const DocumentRectangle *	dr1,
			const DocumentRectangle *	dr2	)
    {
    if  ( dr1->drX0 < dr2->drX0 )
	{ dr->drX0= dr1->drX0;	}
    else{ dr->drX0= dr2->drX0;	}

    if  ( dr1->drY0 < dr2->drY0 )
	{ dr->drY0= dr1->drY0;	}
    else{ dr->drY0= dr2->drY0;	}

    if  ( dr1->drX1 < dr2->drX1 )
	{ dr->drX1= dr2->drX1;	}
    else{ dr->drX1= dr1->drX1;	}

    if  ( dr1->drY1 < dr2->drY1 )
	{ dr->drY1= dr2->drY1;	}
    else{ dr->drY1= dr1->drY1;	}
    }

int docIntersectRectangle(	DocumentRectangle *		dr,
				const DocumentRectangle *	dr1,
				const DocumentRectangle *	dr2	)
    {
    DocumentRectangle	res= *dr1;

    if  ( dr1->drX1 < dr2->drX0 )
	{ return 0;	}

    if  ( dr2->drX1 < dr1->drX0 )
	{ return 0;	}

    if  ( dr1->drY1 < dr2->drY0 )
	{ return 0;	}

    if  ( dr2->drY1 < dr1->drY0 )
	{ return 0;	}

    if  ( dr1->drX0 < dr2->drX0 )
	{ res.drX0= dr2->drX0;	}
    else{ res.drX0= dr1->drX0;	}

    if  ( dr1->drY0 < dr2->drY0 )
	{ res.drY0= dr2->drY0;	}
    else{ res.drY0= dr1->drY0;	}

    if  ( dr1->drX1 < dr2->drX1 )
	{ res.drX1= dr1->drX1;	}
    else{ res.drX1= dr2->drX1;	}

    if  ( dr1->drY1 < dr2->drY1 )
	{ res.drY1= dr1->drY1;	}
    else{ res.drY1= dr2->drY1;	}

    *dr= res; return 1;
    }

void appInitDocumentGeometry(	DocumentGeometry *	dg )
    {
    dg->dgPaperWideTwips= 12240;
    dg->dgPaperHighTwips= 15840;

    dg->dgLeftMarginTwips= 1800;
    dg->dgTopMarginTwips= 1440;
    dg->dgRightMarginTwips= 1800;
    dg->dgBottomMarginTwips= 1440;
    }

/************************************************************************/
/*									*/
/*  Copy a document Geometry. Because of the approximative character of	*/
/*  unit conversions in the conversion back and forth between string	*/
/*  and number, a certain inaccuracy is used to decide whether values	*/
/*  changed or not.							*/
/*									*/
/************************************************************************/

static void appGeoSetNumber(	int *	pTarget,
				int	value,
				int *	pChanged )
    {
    int		d= *pTarget- value;
    int		g;

    if  ( *pTarget == value )
	{ return;	}

    if  ( *pTarget > 200 )
	{
	g= *pTarget/200;

	if  ( d <= g && d >= -g )
	    { return;	}
	}
    else{
	if  ( value > 200 )
	    {
	    g= value/200;

	    if  ( d <= g && d >= -g )
		{ return;	}
	    }
	}

    *pTarget= value; *pChanged= 1;
    }

void appSetDocumentGeometry(	DocumentGeometry *		dgTo,
				const DocumentGeometry *	dgFrom,
				int *				pChanged )
    {
    int		changed= 0;

    appGeoSetNumber( &dgTo->dgPaperWideTwips,
					dgFrom->dgPaperWideTwips, &changed );
    appGeoSetNumber( &dgTo->dgPaperHighTwips,
					dgFrom->dgPaperHighTwips, &changed );
    appGeoSetNumber( &dgTo->dgLeftMarginTwips,
					dgFrom->dgLeftMarginTwips, &changed );
    appGeoSetNumber( &dgTo->dgTopMarginTwips,
					dgFrom->dgTopMarginTwips, &changed );
    appGeoSetNumber( &dgTo->dgRightMarginTwips,
					dgFrom->dgRightMarginTwips, &changed );
    appGeoSetNumber( &dgTo->dgBottomMarginTwips,
					dgFrom->dgBottomMarginTwips, &changed );

    *pChanged= changed;

    return;
    }

