/************************************************************************/
/*									*/
/*  Simple io streams using the C stdio.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>

#   include	<X11/Xlib.h>
#   include	<X11/Xatom.h>

#   include	<sioXprop.h>

#   include	<debugon.h>

static int sioXpropClose(	void *	voidp )
    { free( voidp ); return 0;	}

static int sioXpropSeek(	void *			voidp,
				long			pos )
    { LDEB(pos); return -1;	}

typedef struct XpropInputStream
    {
    Display *		xisDisplay;
    Window		xisWindow;
    Atom		xisProperty;
    long		xisOffset;
    long		xisExhausted;
    } XpropInputStream;

static int sioInXpropReadBytes(	void *		voidxis,
				unsigned char *	buffer,
				int		count )
    {
    XpropInputStream *	xis= (XpropInputStream *)voidxis;

    Atom		typeFound;
    int			formatFound;

    unsigned long	itemsReturned;
    unsigned long	itemsLeft;
    unsigned char *	dataReturned;

    int			ret;

    if  ( xis->xisExhausted )
	{ return -1;	}

    ret= XGetWindowProperty( xis->xisDisplay, xis->xisWindow, xis->xisProperty,
		    xis->xisOffset/4, count/4, False, AnyPropertyType,
		    &typeFound, &formatFound,
		    &itemsReturned, &itemsLeft, &dataReturned );

    if  ( ret != Success )
	{ LLDEB(ret,Success); return -1;	}
    if  ( itemsReturned == 0 )
	{ LDEB(itemsReturned); return -1;	}
    if  ( formatFound != 8 )
	{ LLDEB(typeFound,formatFound); return -1;	}

    memcpy( buffer, dataReturned, itemsReturned );
    XFree( dataReturned );

    xis->xisOffset += itemsReturned;
    if  ( itemsLeft == 0 )
	{ xis->xisExhausted= 1;	}

    return itemsReturned;
    }

SimpleInputStream * sioInXpropOpen(	Display *	display,
					Window		win,
					Atom		property )
    {
    SimpleInputStream *	sis;
    XpropInputStream *	xis;

    xis= (XpropInputStream *)malloc( sizeof( XpropInputStream ) );
    if  ( ! xis )
	{ XDEB(xis); return (SimpleInputStream *)0;	}

    xis->xisDisplay= display;
    xis->xisWindow= win;
    xis->xisProperty= property;
    xis->xisOffset= 0L;
    xis->xisExhausted= 0;

    sis= sioInOpen( (void *)xis,
		sioInXpropReadBytes, sioXpropSeek, sioXpropClose );

    if  ( ! sis )
	{ XDEB(sis); free( xis ); return (SimpleInputStream *)0; }

    return sis;
    }

int sioInXpropEraseAndClose(	SimpleInputStream *	sis )
    {
    int			rval= 0;
    XpropInputStream *	xis= (XpropInputStream *)sis->sisPrivate;

    Atom		typeFound;
    int			formatFound;

    unsigned long	itemsReturned;
    unsigned long	itemsLeft;
    unsigned char *	dataReturned;

    int			ret;

    ret= XGetWindowProperty( xis->xisDisplay, xis->xisWindow, xis->xisProperty,
		    0L, 0, True, AnyPropertyType,
		    &typeFound, &formatFound,
		    &itemsReturned, &itemsLeft, &dataReturned );

    if  ( ret != Success )
	{ LLDEB(ret,Success); rval= -1;	}

    if  ( sioInClose( sis ) )
	{ LDEB(1); rval= -1;	}

    return rval;
    }

typedef struct XpropOutputStream
    {
    Display *		xosDisplay;
    Window		xosRequestor;
    Atom		xosProperty;
    Atom		xosTarget;
    int			xosPropMode;
    } XpropOutputStream;

static int sioOutXpropWriteBytes(	void *			voidxsc,
					const unsigned char *	buffer,
					int			count )
    {
    XpropOutputStream *	xos= (XpropOutputStream *)voidxsc;

    XChangeProperty( xos->xosDisplay, xos->xosRequestor,
				xos->xosProperty, xos->xosTarget,
				8, xos->xosPropMode, buffer, count );

    xos->xosPropMode= PropModeAppend;

    return count;
    }

SimpleOutputStream * sioOutXpropOpen(	Display *		display,
					Window			requestor,
					Atom			property,
					Atom			target )
    {
    SimpleOutputStream *	sos;
    XpropOutputStream *		xos;

    xos= (XpropOutputStream *)malloc( sizeof( XpropOutputStream ) );
    if  ( ! xos )
	{ XDEB(xos); return (SimpleOutputStream *)0;	}

    xos->xosDisplay= display;
    xos->xosRequestor=requestor;
    xos->xosProperty=property;
    xos->xosTarget=target;
    xos->xosPropMode= PropModeReplace;

    sos= sioOutOpen( (void *)xos, sioOutXpropWriteBytes,
						sioXpropSeek, sioXpropClose );

    if  ( ! sos )
	{ XDEB(sos); free( xos ); return (SimpleOutputStream *)0; }

    return sos;
    }
