#   include	<stddef.h>
#   include	<stdlib.h>

#   include	<appWinMeta.h>
#   include	<appPs.h>
#   include	<sioEndian.h>

#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	<debugon.h>

#   ifndef	M_PI
#	define	M_PI	3.14159265358979323846
#   endif

# if 0
#    define	WMFDEB(x)	(x)
# else
#    define	WMFDEB(x)	/*nothing*/
# endif

int appMetaInitDeviceContext(	DeviceContext *		dc,
				int			objectCount,
				int			xExt,
				int			yExt,
				int			twipsWide,
				int			twipsHigh )
    {
    dc->dcDrawBorders= 1;
    dc->dcFillInsides= 1;
    dc->dcString= (unsigned char *)0;

    dc->dcPen.lpStyle= PS_SOLID;
    dc->dcPen.lpWidth= 1;
    dc->dcPen.lpColor.rgb8Red= 0;
    dc->dcPen.lpColor.rgb8Green= 0;
    dc->dcPen.lpColor.rgb8Blue= 0;

    dc->dcBrush.lbStyle= BS_SOLID;
    dc->dcBrush.lbColor.rgb8Red= 255;
    dc->dcBrush.lbColor.rgb8Green= 255;
    dc->dcBrush.lbColor.rgb8Blue= 255;

    dc->dcBkColor.rgb8Red= 255;
    dc->dcBkColor.rgb8Green= 255;
    dc->dcBkColor.rgb8Blue= 255;

    dc->dcTextColor.rgb8Red= 0;
    dc->dcTextColor.rgb8Green= 0;
    dc->dcTextColor.rgb8Blue= 0;

    dc->dcBkMode= BKMODE_OPAQUE;

    dc->dcExtraTextSpacing= 0;
    dc->dcJustificationAmount= 0;
    dc->dcJustificationSpaces= 0;
    dc->dcTextAlignment= TA_LEFT|TA_TOP;

    dc->dcOrgX= 0;
    dc->dcOrgY= 0;
    dc->dcExtX= xExt;
    dc->dcExtY= yExt;
    dc->dcTwipsWide= twipsWide;
    dc->dcTwipsHigh= twipsHigh;

    dc->dcObjects= (MetaFileObject *)0;
    dc->dcObjectCount= 0;

    if  ( objectCount > 0 )
	{
	int		ob;

	dc->dcObjects= (MetaFileObject *)malloc( objectCount* sizeof(MetaFileObject) );
	if  ( ! dc->dcObjects )
	    { XDEB(dc->dcObjects); return -1;	}

	for ( ob= 0; ob < objectCount; ob++ )
	    { dc->dcObjects[ob].mfoType= MFtypeFREE;	}

	dc->dcObjectCount= objectCount;
	}

    dc->dcPoints= (XPoint *)0;
    dc->dcAfi= (AfmFontInfo *)0;

    return 0;
    }

void appMetaCleanObject( MetaFileObject *	mfo )
    {
    switch( mfo->mfoType )
	{
	case MFtypeFREE:
	    return;
	case MFtypeBRUSH:
	    return;
	case MFtypePEN:
	    return;
	case MFtypeFONT:
	    return;
	case MFtypePALETTE:
	    return;
	case MFtypePATTERNBRUSH:
	    LDEB(mfo->mfoType);
	    return;
	default:
	    LDEB(mfo->mfoType);
	    return;
	}
    }

void appMetaCleanDeviceContext(	DeviceContext *		dc )
    {
    int		ob;

    if  ( dc->dcString )
	{ free( dc->dcString );	}

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType != MFtypeFREE )
	    { appMetaCleanObject( dc->dcObjects+ ob );	}
	}

    if  ( dc->dcObjects )
	{ free( dc->dcObjects );	}

    if  ( dc->dcPoints )
	{ free( dc->dcPoints );	}

    return;
    }

int appMetaGetColor(		SimpleInputStream *	sis,
				RGB8Color *		rgb8 )
    {
    rgb8->rgb8Red= sioInGetCharacter( sis );
    rgb8->rgb8Green= sioInGetCharacter( sis );
    rgb8->rgb8Blue= sioInGetCharacter( sis );

    (void) sioInGetCharacter( sis );

    return 0;
    }

int appMetaCreateBrushIndirect(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int			ob;
    int			ignore;

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType == MFtypeFREE )
	    { break;	}
	}
    dc->dcObjects[ob].mfoType= MFtypeBRUSH;

    dc->dcObjects[ob].mfoLogicalBrush.lbStyle= sioEndianGetLeInt16( sis );
    
    switch( dc->dcObjects[ob].mfoLogicalBrush.lbStyle )
	{
	case BS_SOLID:
	    appMetaGetColor( sis, &dc->dcObjects[ob].mfoLogicalBrush.lbColor );
	    ignore= sioEndianGetLeInt16( sis );
	    break;
	case BS_HOLLOW:
	    ignore= sioEndianGetLeInt16( sis );
	    ignore= sioEndianGetLeInt16( sis );
	    ignore= sioEndianGetLeInt16( sis );
	    break;
	case BS_HATCHED:
	    appMetaGetColor( sis, &dc->dcObjects[ob].mfoLogicalBrush.lbColor );
	    dc->dcObjects[ob].mfoLogicalBrush.lbHatch=
						sioEndianGetLeInt16( sis );
	    break;
	case BS_PATTERN:
	    ignore= sioEndianGetLeInt16( sis );
	    dc->dcObjects[ob].mfoLogicalBrush.lbHatch=
						sioEndianGetLeInt32( sis );
	    break;
	default:
	    LDEB(dc->dcObjects[ob].mfoLogicalBrush.lbStyle);
	}

    WMFDEB(DEBFUN("CreateBrushIndirect(style=%d,...) ob=%d\n",
			    dc->dcObjects[ob].mfoLogicalBrush.lbStyle, ob ));

    return 0;
    }

int appMetaCreatePalette(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int			ob;
    int			ignore;
    int			done;
    int			count;

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType == MFtypeFREE )
	    { break;	}
	}
    dc->dcObjects[ob].mfoType= MFtypePALETTE;

    ignore= sioEndianGetLeInt16( sis );
    count= sioEndianGetLeInt16( sis );
    /*
    if  ( 2* count != recordSize- 5 )
	{ LLDEB(count,recordSize);	}
    */
    for ( done= 5; done < recordSize; done++ )
	{ ignore= sioEndianGetLeInt16( sis ); }

    WMFDEB(DEBFUN("CreatePalette(...) ob=%d\n", ob ));

    return 0;
    }

int appMetaCreatePatternBrush(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int			ob;
    int			ignore;
    int			done;

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType == MFtypeFREE )
	    { break;	}
	}
    dc->dcObjects[ob].mfoType= MFtypePATTERNBRUSH;

    for ( done= 3; done < recordSize; done++ )
	{ ignore= sioEndianGetLeInt16( sis ); }

    WMFDEB(DEBFUN("CreatePatternBrush(...) ob=%d\n", ob ));

    return 0;
    }

int appMetaCreatePenIndirect(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int			ob;
    int			ignore;
    int			done;

    int			x;
    int			y;

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType == MFtypeFREE )
	    { break;	}
	}
    dc->dcObjects[ob].mfoType= MFtypePEN;

    dc->dcObjects[ob].mfoLogicalPen.lpStyle= sioEndianGetLeInt16( sis );
    x= sioEndianGetLeInt16( sis );
    y= sioEndianGetLeInt16( sis );
    dc->dcObjects[ob].mfoLogicalPen.lpWidth= x;
    appMetaGetColor( sis, &dc->dcObjects[ob].mfoLogicalPen.lpColor );

    WMFDEB(DEBFUN("CreatePenIndirect( style=%d,x,y=%d,%d) ob=%d\n",
				dc->dcObjects[ob].mfoLogicalPen.lpStyle,
				x,y, ob ));

    for ( done= 8; done < recordSize; done++ )
	{ ignore= sioEndianGetLeInt16( sis ); }

    return 0;
    }

int appMetaCreateFontIndirect(	DeviceContext *		dc,
				DocumentFontList *	dfl,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    LogicalFont *	lf;
    DocumentFont *	df;

    char *		familyStyle= "fnil";

    int			count;
    int			done;
    int			ob;
    int			i;

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType == MFtypeFREE )
	    { break;	}
	}
    dc->dcObjects[ob].mfoType= MFtypeFONT;

    lf= &(dc->dcObjects[ob].mfoLogicalFont);

    lf->lfHeight= sioEndianGetLeInt16( sis );
    lf->lfWidth= sioEndianGetLeInt16( sis );
    lf->lfEscapement= sioEndianGetLeInt16( sis );
    lf->lfOrientation= sioEndianGetLeInt16( sis );
    lf->lfWeight= sioEndianGetLeInt16( sis );

    lf->lfItalic= sioInGetCharacter( sis );
    lf->lfUnderline= sioInGetCharacter( sis );
    lf->lfStrikeOut= sioInGetCharacter( sis );
    lf->lfCharSet= sioInGetCharacter( sis );
    lf->lfOutPrecision= sioInGetCharacter( sis );
    lf->lfClipPrecision= sioInGetCharacter( sis );
    lf->lfQuality= sioInGetCharacter( sis );
    lf->lfPitchAndFamily= sioInGetCharacter( sis );

    count= 0;
    for ( done= 12; done < recordSize; done++ )
	{
	lf->lfFaceName[count++]= sioInGetCharacter( sis );
	lf->lfFaceName[count++]= sioInGetCharacter( sis );
	}

    lf->lfFaceName[count]= '\0';

    if  ( lf->lfHeight < 0 )
	{ done= ( dc->dcTwipsHigh* -lf->lfHeight )/ dc->dcExtY; }
    else{ done= ( dc->dcTwipsHigh*  lf->lfHeight )/ dc->dcExtY; }

    lf->lfTextAttribute.taFontNumber= 0;
    lf->lfTextAttribute.taFontSizeHalfPoints= done/ 10;
    lf->lfTextAttribute.taFontIsBold= lf->lfWeight > 500;
    lf->lfTextAttribute.taFontIsSlanted= lf->lfItalic != 0;
    lf->lfTextAttribute.taIsUnderlined= lf->lfUnderline != 0;

    switch( lf->lfPitchAndFamily & 0xf0 )
	{
	case FF_ROMAN:		familyStyle= "froman";	break;
	case FF_SWISS:		familyStyle= "fswiss";	break;
	case FF_MODERN:		familyStyle= "fmodern";	break;
	case FF_SCRIPT:		familyStyle= "fscript";	break;
	case FF_DECORATIVE:	familyStyle= "fdecor";	break;
	case 0x60:		familyStyle= "ftech";	break;

	case FF_DONTCARE:
	default:
	    break;
	}

    df= dfl->dflFonts;
    for ( i= 0; i < dfl->dflCount; df++, i++ )
	{
	if  ( df->dfDocFamilyNumber < 0	 )
	    { continue;	}

	if  ( lf->lfFaceName[0]			&&
	      ! df->dfName			)
	    { continue;	}

	if  ( ! lf->lfFaceName[0]		&&
	      ! df->dfName			)
	    { break;	}

	if  ( ! strcmp( df->dfName, lf->lfFaceName ) )
	    { break;	}
	}

    if  ( i >= dfl->dflCount )
	{
	df= docInsertFont( dfl, -1, familyStyle, lf->lfFaceName );
	if  ( ! df )
	    { SXDEB(lf->lfFaceName,df); return -1;	}
	}

    lf->lfTextAttribute.taFontNumber= df->dfDocFamilyNumber;

    lf->lfPrivateFont= -1;

    WMFDEB(DEBFUN("CreateFontIndirect(...\"%s\") ob=%d\n",
			    dc->dcObjects[ob].mfoLogicalFont.lfFaceName, ob ));

    return 0;
    }

int appMetaDeleteObject(	DeviceContext *		dc,
				int			ob )
    {
    if  ( ob < 0 || ob >= dc->dcObjectCount )
	{ LLDEB(ob,dc->dcObjectCount); return -1;	}

    switch( dc->dcObjects[ob].mfoType )
	{
	case MFtypePEN:
	    WMFDEB(DEBFUN("DeleteObject(%d) PEN\n", ob ));
	    break;
	case MFtypeBRUSH:
	    WMFDEB(DEBFUN("DeleteObject(%d) BRUSH\n", ob ));
	    break;
	case MFtypeFONT:
	    WMFDEB(DEBFUN("DeleteObject(%d) FONT\n", ob ));
	    break;
	default:
	    WMFDEB(DEBFUN("DeleteObject(%d) type= %d\n",
					    ob, dc->dcObjects[ob].mfoType ));
	    break;
	}

    appMetaCleanObject( &(dc->dcObjects[ob]) );

    dc->dcObjects[ob].mfoType= MFtypeFREE;

    return 0;
    }

int appMeta_ExtTextOut(		SimpleInputStream *	sis,
				int			recordSize,
				int *			pX0,
				int *			pY0,
				int *			pCount,
				int *			pStyle,
				int *			pX1,
				int *			pY1,
				int *			pH1,
				int *			pW1,
				DeviceContext *		dc )
    {
    int			x0;
    int			y0;
    int			count;
    int			style;

    int			h1;
    int			w1;
    int			y1;
    int			x1;

    int			done;

    int			ignore;
    int			i;

    unsigned char *	str;

    y0= sioEndianGetLeInt16( sis );
    x0= sioEndianGetLeInt16( sis );
    count= sioEndianGetLeInt16( sis );
    style= sioEndianGetLeInt16( sis );

    done= 7;

    if  ( style )
	{
	h1= sioEndianGetLeInt16( sis );
	w1= sioEndianGetLeInt16( sis );
	y1= sioEndianGetLeInt16( sis );
	x1= sioEndianGetLeInt16( sis );

	done += 4;
	}
    else{ h1= w1= y1= x1= 0;	}

    str= (unsigned char *)realloc( dc->dcString, count+ 2 );
    if  ( ! str )
	{ LXDEB(count,str); return -1;	}
    dc->dcString= str;

    for ( i= 0; i < count; i += 2 )
	{
	str[i+0]= sioInGetCharacter( sis );
	str[i+1]= sioInGetCharacter( sis );
	done++;
	}
    str[count]= '\0';

    for ( ; done < recordSize; done++ )
	{ ignore= sioEndianGetLeInt16( sis ); }

    WMFDEB(DEBFUN( "ExtTextOut( x=%d, y= %d, opts= %d, rect=[%d+%d,%d+%d], ",
					    x0, y0, style, x1, w1, y1, h1 ));
    WMFDEB(DEBFUN( "\"%s\", count= %d, .... )\n", str, count ));

    *pX0= x0;
    *pY0= y0;
    *pCount= count;
    *pStyle= style;
    *pX1= x1;
    *pY1= y1;
    *pH1= h1;
    *pW1= w1;

    return 0;
    }

int appMeta_TextOut(	SimpleInputStream *	sis,
			int			recordSize,
			int *			pX0,
			int *			pY0,
			int *			pCount,
			DeviceContext *		dc )
    {
    int			x0;
    int			y0;
    int			count;

    int			i;

    unsigned char *	str;

    count= sioEndianGetLeInt16( sis );

    str= (unsigned char *)realloc( dc->dcString, count+ 2 );
    if  ( ! str )
	{ LXDEB(count,str); return -1;	}
    dc->dcString= str;

    for ( i= 0; i < count; i += 2 )
	{
	str[i+0]= sioInGetCharacter( sis );
	str[i+1]= sioInGetCharacter( sis );
	}
    str[count]= '\0';

    y0= sioEndianGetLeInt16( sis );
    x0= sioEndianGetLeInt16( sis );

    WMFDEB(DEBFUN("TextOut( \"%s\", x=%d, y= %d )\n", str, x0, y0 ));

    *pX0= x0;
    *pY0= y0;
    *pCount= count;

    return 0;
    }

int appMeta_GetCounts(	SimpleInputStream *	sis,
			int			recordSize,
			int *			pCount,
			int **			pCounts,
			DeviceContext *		dc )
    {
    int			count;
    int			i;

    static int *	counts;

    count= sioEndianGetLeInt16( sis );

    counts= (int *)realloc( counts, count* sizeof(int) );
    if  ( ! counts )
	{ LXDEB(count,counts); return -1;	}

    for ( i= 0; i < count; i++ )
	{ counts[i]= sioEndianGetLeInt16( sis ); }

    *pCount= count; *pCounts= counts; return 0;
    }

int appMetaSaveBitmapMetafile(	const BitmapDescription *	bd,
				const unsigned char *		buffer,
				SimpleOutputStream *		sos )
    {
    int			done;
    int			bytesWritten= 0;
    long		bltArgCountPos= -1L;
    long		bltArgCount;

    long		fileSize= 0L;
    long		headerOffset= 0L;
    long		recordSize;
    long		maxRecordSize= 0L;

    sioEndianPutLeInt16( 1, sos );		/*  fileType		*/
    sioEndianPutLeInt16( 9, sos );		/*  headerSize		*/
    sioEndianPutLeInt16( 768, sos );		/*  windowsVersion	*/
    sioEndianPutLeInt32( fileSize, sos );	/*  fileSize		*/
    sioEndianPutLeInt16( 0, sos );		/*  objectCount		*/
    sioEndianPutLeInt32( maxRecordSize, sos );	/*  maxRecordSize	*/
    sioEndianPutLeInt16( 0, sos );		/*  parameterCount	*/

    bytesWritten += 2+ 2+ 2+ 4+ 2+ 4+ 2;

    recordSize= 2+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_SaveDC, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    recordSize= 2+ 1+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_SetMapMode, sos );
    sioEndianPutLeInt16( MM_ANISOTROPIC, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    recordSize= 2+ 1+ 1+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_SetWindowOrg, sos );
    sioEndianPutLeInt16( 0, sos );
    sioEndianPutLeInt16( 0, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    recordSize= 2+ 1+ 1+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_SetWindowExt, sos );
    sioEndianPutLeInt16( bd->bdPixelsHigh, sos );
    sioEndianPutLeInt16( bd->bdPixelsWide, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    bltArgCountPos= bytesWritten;
    recordSize= 2+ 1+ 2+ ( 1+ 1+ 1+ 1 )+ ( 1+ 1+ 1+ 1 );
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_StretchBlt, sos );
    sioEndianPutLeInt32( 0xcc0020, sos );
    sioEndianPutLeInt16( bd->bdPixelsHigh, sos );
    sioEndianPutLeInt16( bd->bdPixelsWide, sos );
    sioEndianPutLeInt16( 0, sos );
    sioEndianPutLeInt16( 0, sos );
    sioEndianPutLeInt16( bd->bdPixelsHigh, sos );
    sioEndianPutLeInt16( bd->bdPixelsWide, sos );
    sioEndianPutLeInt16( 0, sos );
    sioEndianPutLeInt16( 0, sos );

    done= bmBmpSaveDib( bd, buffer, bytesWritten+ 2* recordSize, (void *)sos );
    if  ( done < 0 || done % 2 )
	{ LDEB(done); return -1;	}

    recordSize += done/ 2;
    bltArgCount= recordSize;

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    recordSize= 2+ 1+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_RestoreDC, sos );
    sioEndianPutLeInt16( -1, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    recordSize= 2+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( 0, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    fileSize= bytesWritten;

    if  ( sioOutSeek( sos, headerOffset ) )
	{ LDEB(headerOffset); return -1; }

    sioEndianPutLeInt16( 1, sos );		/*  fileType		*/
    sioEndianPutLeInt16( 9, sos );		/*  headerSize		*/
    sioEndianPutLeInt16( 768, sos );		/*  windowsVersion	*/
    sioEndianPutLeInt32( fileSize, sos );	/*  fileSize		*/
    sioEndianPutLeInt16( 0, sos );		/*  objectCount		*/
    sioEndianPutLeInt32( maxRecordSize, sos );	/*  maxRecordSize	*/
    sioEndianPutLeInt16( 0, sos );		/*  parameterCount	*/

    if  ( sioOutSeek( sos, bltArgCountPos ) )
	{ LDEB(headerOffset); return -1; }

    sioEndianPutLeInt32( bltArgCount, sos );

    if  ( sioOutSeek( sos, fileSize ) )
	{ LDEB(headerOffset); return -1; }

    return 0;
    }
