/************************************************************************/
/*									*/
/*  Retrieve images.							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	"appFrame.h"
#   include	"appIcons.h"

#   include	<X11/xpm.h>

#   include	<debugon.h>

static XpmAttributes	APP_XpmAttributes;

int appGetImagePixmap(	EditApplication *	ea,
			const char *		name,
			Pixmap *		pPixmap )
    {
    int			i;
    int			res;
    NamedPicture *	np;

    Pixmap		pixmap= (Pixmap)0;
    Pixmap		shapeMask= (Pixmap)0;

    if  ( ! APP_XpmAttributes.valuemask )
	{
	APP_XpmAttributes.valuemask= XpmRGBCloseness;

	APP_XpmAttributes.red_closeness= 8;
	APP_XpmAttributes.green_closeness= 8;
	APP_XpmAttributes.blue_closeness= 16;
	}

    np= ea->eaNamedPictures;
    for ( i= 0; i < ea->eaNamedPictureCount; np++, i++ )
	{
	if  ( ! strcmp( name, np->npPictureName ) )
	    { break;	}
	}

    if  ( i >= ea->eaNamedPictureCount )
	{ SLDEB(name,ea->eaNamedPictureCount); return -1;	}

    if  ( np->npPixmap )
	{ *pPixmap= np->npPixmap; return 0;	}

    res= XpmCreatePixmapFromData( ea->eaDisplay,
		RootWindow( ea->eaDisplay, DefaultScreen( ea->eaDisplay ) ),
		np->npBuffer, &pixmap, &shapeMask,
		&APP_XpmAttributes );

    while( res == XpmColorFailed && APP_XpmAttributes.red_closeness < 10000 )
	{
	APP_XpmAttributes.red_closeness *= 2;
	APP_XpmAttributes.green_closeness *= 2;
	APP_XpmAttributes.blue_closeness *= 2;

	res= XpmCreatePixmapFromData( ea->eaDisplay,
		RootWindow( ea->eaDisplay, DefaultScreen( ea->eaDisplay ) ),
		np->npBuffer, &pixmap, &shapeMask,
		&APP_XpmAttributes );
	}

    if  ( res )
	{ SLDEB(name,res); return -1;	}

    np->npPixmap= pixmap;

    *pPixmap= pixmap; return 0;
    }

void appDiscardImagePixmaps(	EditApplication *	ea )
    {
    int			i;
    NamedPicture *	np;

    np= ea->eaNamedPictures;
    for ( i= 0; i < ea->eaNamedPictureCount; np++, i++ )
	{
	if  ( np->npPixmap )
	    { XFreePixmap( ea->eaDisplay, np->npPixmap ); np->npPixmap= None; }
	}

    return;
    }
