/************************************************************************/
/*  Ted, main module.							*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>

#   include	<appGeo.h>
#   include	"appDraw.h"

#   include	<debugon.h>

/************************************************************************/
/*  Collect exposures for optimised drawing.				*/
/************************************************************************/

void appCollectExposures(	DocumentRectangle *	drClip,
				int			ox,
				int			oy,
				Display *		display,
				Window			win,
				GC			gc,
				XEvent *		event )
    {
    Region		region;

    region= XCreateRegion();
    XtAddExposureToRegion( event, region );

    drClip->drX0= ox+ event->xexpose.x;
    drClip->drY0= oy+ event->xexpose.y;
    drClip->drX1= ox+ event->xexpose.x+ event->xexpose.width;
    drClip->drY1= oy+ event->xexpose.y+ event->xexpose.height;

    /*
    printf( "======: [%4d+%4d]x[%4d+%4d]\n",
		    drClip->drX0,
		    drClip->drX1- drClip->drX0+ 1,
		    drClip->drY0,
		    drClip->drY1- drClip->drY0+ 1 );
    */

    while( QLength( display ) > 0 )
	{
	XEvent			nextEvent;
	DocumentRectangle	drMore;

	XPeekEvent( display, &nextEvent );

	if  ( nextEvent.type != Expose && nextEvent.type != GraphicsExpose )
	    { break;	}
	if  ( nextEvent.xexpose.window != win )
	    { break;	}

	XNextEvent( display, &nextEvent );
	XtAddExposureToRegion( &nextEvent, region );
	drMore.drX0= ox+ nextEvent.xexpose.x;
	drMore.drY0= oy+ nextEvent.xexpose.y;
	drMore.drX1= ox+ nextEvent.xexpose.x+ nextEvent.xexpose.width;
	drMore.drY1= oy+ nextEvent.xexpose.y+ nextEvent.xexpose.height;

	/*
	printf( "++++++: [%4d+%4d]x[%4d+%4d]\n",
			drMore.drX0,
			drMore.drX1- drMore.drX0+ 1,
			drMore.drY0,
			drMore.drY1- drMore.drY0+ 1 );
	*/

	docUnionRectangle( drClip, drClip, &drMore );

	/*
	printf( "......: [%4d+%4d]x[%4d+%4d]\n",
			drClip->drX0,
			drClip->drX1- drClip->drX0+ 1,
			drClip->drY0,
			drClip->drY1- drClip->drY0+ 1 );
	*/
	}

    XSetRegion( display, gc, region );

    XDestroyRegion( region );

    return;
    }

/************************************************************************/
/*  Initialise drawing data.						*/
/************************************************************************/

void appInitDrawingData(	AppDrawingData *	add )
    {
    add->sgMagnification= 1.0;
    add->addMagnifiedPixelsPerTwip= 0.0;
    add->addAfmDirectory= (char *)0;
    add->addDisplay= (Display *)0;

    appInitFontList( &(add->addPhysicalFontList) );
    }

void appCleanDrawingData(	AppDrawingData *	add )
    {
    if  ( add->addDisplay )
	{ appCleanFontList( add->addDisplay, &(add->addPhysicalFontList) ); }

    return ;
    }
