#####################################################################
##
##   Look for libxpm
##
#####################################################################

AC_DEFUN(AC_PATH_XPM,
[
    echo Checking for libxpm...

    XPM_CFLAGS=
    XPM_LIBS=

    ac_xpm_includes=NO
    ac_xpm_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/X11R6/include	\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/apps/include	\
	../xpm
    do
    if  test -r "$ac_dir/X11/xpm.h"
	then
	    ac_xpm_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/X11R6/lib		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/apps/lib		\
	../xpm/lib
    do
    if  test -r "$ac_dir/libXpm.a"
	then
	    ac_xpm_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_xpm_includes
    #echo Libraries: $ac_xpm_libraries

    if  test $ac_xpm_includes != NO
    then
	XPM_CFLAGS=-I$ac_xpm_includes

	if  test "$XPM_CFLAGS" = "$X_CFLAGS"
	then
	    XPM_CFLAGS=
	fi
    fi

    if  test $ac_xpm_libraries != NO
    then
	XPM_LIBS="-L$ac_xpm_libraries"

	if  test "$XPM_LIBS" = "$X_LIBS"
	then
	    XPM_LIBS=
	fi
    fi

    AC_SUBST(XPM_CFLAGS)dnl
    AC_SUBST(XPM_LIBS)dnl
])
#####################################################################
##
##   Look for Motif
##
#####################################################################

AC_DEFUN(AC_PATH_XM,
[
    echo Checking for Motif...

    XM_CFLAGS=
    XM_LIBS=
    XM_EXTRA_LIBS=

    ac_xm_includes=NO
    ac_xm_libraries=NO

    # Includes
    for ac_dir in			\
	/usr/X11R6/include		\
	/usr/local/include		\
	/usr/dt/include			\
	/opt/SUNWmotif/include		\
	/usr/apps/include		\
	/usr/local/LessTif/include
    do
    if  test -r "$ac_dir/Xm/Xm.h"
	then
	    ac_xm_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in			\
	/usr/X11R6/lib			\
	/usr/local/lib			\
	/usr/dt/lib			\
	/opt/SUNWmotif/lib		\
	/usr/apps/lib			\
	/usr/local/LessTif/include
    do
    if  test -r "$ac_dir/libXm.a"
	then
	    ac_xm_libraries=$ac_dir
	    break
	fi

    if  test -r "$ac_dir/libXm.so"
	then
	    ac_xm_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_xm_includes
    #echo Libraries: $ac_xm_libraries

    if  test $ac_xm_includes != NO
    then
	XM_CFLAGS=-I$ac_xm_includes

	if  test "$XM_CFLAGS" = "$X_CFLAGS"
	then
	    XM_CFLAGS=
	fi
    fi

    if  test $ac_xm_libraries != NO
    then
	XM_LIBS="-L$ac_xm_libraries"

	if  test "$XM_LIBS" = "$X_LIBS"
	then
	    XM_LIBS=
	fi
    fi

    #  Too simple..
    #  AC_CHECK_LIB( Xp, XpStartPage, XM_EXTRA_LIBS="-lXp" )
    if  test -r $ac_xm_libraries/libXp.a
    then
	XM_EXTRA_LIBS="-lXp"
    else
	if  test -r $ac_xm_libraries/libXp.so
	then
	    XM_EXTRA_LIBS="-lXp"
	fi
    fi

    AC_SUBST(XM_CFLAGS)dnl
    AC_SUBST(XM_LIBS)dnl
    AC_SUBST(XM_EXTRA_LIBS)dnl
])
