/************************************************************************/
/*									*/
/*  A Format Tool.							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<debugon.h>

#   include	<Xm/Text.h>

#   include	<appUtil.h>
#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Refresh the 'Column' page of the format tool.			*/
/*									*/
/************************************************************************/

void tedFormatToolRefreshColumnPage(	ColumnTool *	ct )
    {
    RowProperties *	rp= &(ct->ctPropertiesChosen);
    CellProperties *	cp;

    int			width;
    char		scratch[50];

    sprintf( scratch, "%d", ct->ctCol0+ 1 );
    XmTextSetString( ct->ctNumberText, scratch );

    if  ( ct->ctCol0 == 0 )
	{
	width= rp->rpCells[ct->ctCol0  ].cpRightBoundaryTwips-
						    rp->rpLeftIndentTwips;
	}
    else{
	width= rp->rpCells[ct->ctCol0  ].cpRightBoundaryTwips-
			    rp->rpCells[ct->ctCol0-1].cpRightBoundaryTwips;
	}

    appGeoLengthToString( scratch, width, UNITtyPOINTS );
    XmTextSetString( ct->ctWidthText, scratch );

    cp= rp->rpCells;

    tedFormatReflectBorder( ct->ctLeftBorderToggle,
					&(cp[ct->ctCol0].cpLeftBorder) );
    tedFormatReflectBorder( ct->ctRightBorderToggle,
					&(cp[ct->ctCol0].cpRightBorder) );
    }

static int tedFormatToolGetColumnWidth(	const RowProperties *	rp,
					int			col0,
					int			pageRight,
					int *			pValue,
					int *			pShift,
					Widget			w )
    {
    int				width;
    int				changed;

    const CellProperties *	cp= &(rp->rpCells[col0]);
    int				rightRight;

    int				right;
    int				d;

    const int			requirePositive= 1;
    
    right= cp->cpRightBoundaryTwips;
    if  ( col0 == 0 )
	{ width= right- rp->rpLeftIndentTwips;		}
    else{ width= right- cp[-1].cpRightBoundaryTwips;	}

    if  ( appGetLengthFromTextWidget( w, &width, &changed,
					    UNITtyPOINTS, requirePositive ) )
	{ return -1; }

    if  ( col0 == 0 )
	{ right= rp->rpLeftIndentTwips+ width;		}
    else{ right= cp[-1].cpRightBoundaryTwips+ width;	}

    d= right- cp->cpRightBoundaryTwips;

    rightRight= rp->rpCells[rp->rpCellCount-1].cpRightBoundaryTwips;
    rightRight -= rp->rpHalfGapWidthTwips;

    if  ( rightRight+ d >= pageRight )
	{
	char		scratch[50];

	d= pageRight- rightRight;
	right= cp->cpRightBoundaryTwips+ d;

	if  ( col0 == 0 )
	    { width= right- rp->rpLeftIndentTwips;		}
	else{ width= right- cp[-1].cpRightBoundaryTwips;	}

	width -= 10;

	if  ( width <= 0 )
	    { appRefuseTextValue( w ); return -1;	}

	appGeoLengthToString( scratch, width, UNITtyPOINTS );
	XmTextSetString( w, scratch );
	appRefuseTextValue( w );
	return 1;
	}

    *pValue= width; *pShift= d; return 0;
    }

/************************************************************************/
/*  Set/Revert buttons have been pushed.				*/
/************************************************************************/

static void tedTableChangeColumnPushed(	Widget		w,
					XtPointer	voidct,
					XtPointer	voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    RowProperties *	rp= &(ct->ctPropertiesChosen);
    CellProperties *	cp= &(rp->rpCells[ct->ctCol0]);

    int			col;

    int			d;
    int			width;
    int			res;

    res= tedFormatToolGetColumnWidth( rp, ct->ctCol0,
				ct->ctPageRight, &width, &d, ct->ctWidthText );
    if  ( res != 0 )
	{ return;	}

    for ( col= ct->ctCol0; col < rp->rpCellCount; cp++, col++ )
	{ cp->cpRightBoundaryTwips += d; }

    tedSetTableProperties( ct->ctApplication,
		ct->ctCol0, ct->ctCol1, ct->ctRow00, ct->ctRow11, rp );

    return;
    }

static void tedFormatRevertColumnPushed(	Widget		w,
						XtPointer	voidct,
						XtPointer	voidpbcs )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;

    docCopyRowProperties( &(ct->ctPropertiesChosen), &(ct->ctPropertiesSet) );

    tedFormatToolRefreshColumnPage( ct );

    return;
    }

/************************************************************************/
/*									*/
/*  Check a number as typed by the user.				*/
/*									*/
/************************************************************************/

static void tedColumnWidthChanged(	Widget		w,
					XtPointer	voidct,
					XtPointer	voidpbcs )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    RowProperties *	rp= &(ct->ctPropertiesChosen);

    int			d;
    int			width;

    if  ( ! tedFormatToolGetColumnWidth( rp, ct->ctCol0,
			    ct->ctPageRight, &width, &d, ct->ctWidthText ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, width, UNITtyPOINTS );

	XmTextSetString( ct->ctWidthText, scratch );
	}
    }

/************************************************************************/
/*									*/
/*  Previous/Next Column/Row buttons have been pushed.			*/
/*									*/
/************************************************************************/

static void tedTablePreviousColumn(	Widget		w,
					XtPointer	voidct,
					XtPointer	voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    EditApplication *	ea= ct->ctApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedAppSetTableSelection( ed, ct->ctCol0- 1, ct->ctCol1- 1,
						ct->ctRow0, ct->ctRow1 );
    }

static void tedTableSelectColumn(	Widget		w,
					XtPointer	voidct,
					XtPointer	voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    EditApplication *	ea= ct->ctApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedAppSetTableSelection( ed, ct->ctCol0, ct->ctCol1,
						ct->ctRow00, ct->ctRow11 );
    }

static void tedTableNextColumn(		Widget		w,
					XtPointer	voidct,
					XtPointer	voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    EditApplication *	ea= ct->ctApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedAppSetTableSelection( ed, ct->ctCol0+ 1, ct->ctCol1+ 1,
						ct->ctRow0, ct->ctRow1 );
    }

/************************************************************************/
/*									*/
/*  Delete Column/Row/Table buttons have been pushed.			*/
/*									*/
/************************************************************************/

static void tedTableDeleteColumn(	Widget		w,
					XtPointer	voidct,
					XtPointer	voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    EditApplication *	ea= ct->ctApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( tedDeleteColumnsFromRows( ed,
		ct->ctRow00, ct->ctRow11, ct->ctCol0, ct->ctCol1 ) )
	{ LLDEB(ct->ctRow00,ct->ctRow11); return;	}

    appDocumentChanged( ea, ed, 1 );

    return;
    }

/************************************************************************/
/*									*/
/*  Insert/Append Column/Row buttons have been pushed.			*/
/*									*/
/************************************************************************/

static void tedTableInsertColumn(	Widget		w,
					XtPointer	voidct,
					XtPointer	voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    EditApplication *	ea= ct->ctApplication;

    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedInsertColumnInTable( ed->edDocumentWidget, ed );

    appDocumentChanged( ea, ed, 1 );
    }

static void tedTableAppendColumn(	Widget		w,
					XtPointer	voidct,
					XtPointer	voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    EditApplication *	ea= ct->ctApplication;

    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedAppendColumnToTable( ed->edDocumentWidget, ed );

    appDocumentChanged( ea, ed, 1 );
    }

/************************************************************************/
/*									*/
/*  One of the 'Column Border' toggles has been activated.		*/
/*									*/
/************************************************************************/

static void tedColumnToggleBorder(	Widget		w,
					XtPointer	voidct,
					XtPointer	voidtbcs )
    {
    ColumnTool *			ct= (ColumnTool *)voidct;
    RowProperties *			rp= &(ct->ctPropertiesChosen);
    CellProperties *			cp= &(rp->rpCells[ct->ctCol0]);
    XmToggleButtonCallbackStruct *	tbcs;

    tbcs= (XmToggleButtonCallbackStruct *)voidtbcs;

    if  ( w == ct->ctLeftBorderToggle )
	{
	tedFormatToggleBorder( &(cp->cpLeftBorder), tbcs->set );

	return;
	}

    if  ( w == ct->ctRightBorderToggle )
	{
	tedFormatToggleBorder( &(cp->cpRightBorder), tbcs->set );

	return;
	}

    XDEB(w); return;
    }

/************************************************************************/
/*									*/
/*  Make a column tool, I.E. the 'Column' page of the format tool.	*/
/*									*/
/************************************************************************/

void tedFormatMakeColumnPage(	ColumnTool *		ct,
				Widget			pageParent,
				ColumnPageResources *	cpr,
				ToolSubject *		ts,
				FormatPageResources *	fpr )
    {
    Widget	pageWidget;
    Widget	widthLabel;
    Widget	columnLabel;

    Widget	row= (Widget)0;

    const int	textColumns= 10;

    /**************/
    ct->ctCol0= -1;
    ct->ctCol1= -1;
    ct->ctRow00= -1;
    ct->ctRow0= -1;
    ct->ctRow1= -1;
    ct->ctRow11= -1;

    docInitRowProperties( &(ct->ctPropertiesSet) );
    docInitRowProperties( &(ct->ctPropertiesChosen) );

    /**************/
    pageWidget= tedFormatMakePage( ts, pageParent );

    appMakeLabelAndTextRow( &row, &columnLabel, &(ct->ctNumberText),
			    pageWidget, fpr->fprSubjectName, textColumns, 0 );

    appMakeLabelAndTextRow( &row, &widthLabel, &(ct->ctWidthText),
			pageWidget, cpr->cprWidth, textColumns, 1 );

    XtAddCallback( ct->ctWidthText, XmNactivateCallback,
					tedColumnWidthChanged, (void *)ct );

    tedFormatMakeToggleRow( &row, pageWidget,
	&(ct->ctLeftBorderToggle), &(ct->ctRightBorderToggle),
	cpr->cprLeftBorder, cpr->cprRightBorder,
	tedColumnToggleBorder, tedColumnToggleBorder, (void *)ct );

    tedFormatMakeButtonRow( &row, pageWidget,
		    &(ts->tsPrevButton), &(ts->tsNextButton),
		    fpr->fprPrevButtonText, fpr->fprNextButtonText,
		    tedTablePreviousColumn, tedTableNextColumn, ct );

    tedFormatMakeButtonRow( &row, pageWidget,
		    &(ts->tsSelectButton), &(ts->tsDeleteButton),
		    fpr->fprSelectButtonText, fpr->fprDeleteButtonText,
		    tedTableSelectColumn, tedTableDeleteColumn, ct );

    tedFormatMakeButtonRow( &row, pageWidget,
		    &(ts->tsInsertButton), &(ts->tsAppendButton),
		    fpr->fprInsertButtonText, fpr->fprAppendButtonText,
		    tedTableInsertColumn, tedTableAppendColumn, ct );

    tedFormatMakeButtonRow( &row, pageWidget,
		    &(ts->tsRevertButton), &(ts->tsApplyButton),
		    fpr->fprRevert, fpr->fprApplyToSubject,
		    tedFormatRevertColumnPushed, tedTableChangeColumnPushed,
		    (void *)ct );

    XtManageChild( pageWidget );
    XtManageChild( ts->tsPage );

    return;
    }
