;;; -*- coding: iso-2022-7bit  -*-
;;; uiso8859-8.el --- tables between UCS and ISO-8859-8

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, ISO8859

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from 8859-8.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'hebrew-iso8859-8 'unicode 'iso-8859-8-vs-unicode-assoc)

(defvar
  iso-8859-8-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?,H (B . ?\x00A0) ;; NO-BREAK SPACE
     (?,H"(B . ?\x00A2) ;; CENT SIGN
     (?,H#(B . ?\x00A3) ;; POUND SIGN
     (?,H$(B . ?\x00A4) ;; CURRENCY SIGN
     (?,H%(B . ?\x00A5) ;; YEN SIGN
     (?,H&(B . ?\x00A6) ;; BROKEN BAR
     (?,H'(B . ?\x00A7) ;; SECTION SIGN
     (?,H((B . ?\x00A8) ;; DIAERESIS
     (?,H)(B . ?\x00A9) ;; COPYRIGHT SIGN
     (?,H*(B . ?\x00D7) ;; MULTIPLICATION SIGN
     (?,H+(B . ?\x00AB) ;; LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
     (?,H,(B . ?\x00AC) ;; NOT SIGN
     (?,H-(B . ?\x00AD) ;; SOFT HYPHEN
     (?,H.(B . ?\x00AE) ;; REGISTERED SIGN
     (?,H/(B . ?\x203E) ;; OVERLINE
     (?,H0(B . ?\x00B0) ;; DEGREE SIGN
     (?,H1(B . ?\x00B1) ;; PLUS-MINUS SIGN
     (?,H2(B . ?\x00B2) ;; SUPERSCRIPT TWO
     (?,H3(B . ?\x00B3) ;; SUPERSCRIPT THREE
     (?,H4(B . ?\x00B4) ;; ACUTE ACCENT
     (?,H5(B . ?\x00B5) ;; MICRO SIGN
     (?,H6(B . ?\x00B6) ;; PILCROW SIGN
     (?,H7(B . ?\x00B7) ;; MIDDLE DOT
     (?,H8(B . ?\x00B8) ;; CEDILLA
     (?,H9(B . ?\x00B9) ;; SUPERSCRIPT ONE
     (?,H:(B . ?\x00F7) ;; DIVISION SIGN
     (?,H;(B . ?\x00BB) ;; RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
     (?,H<(B . ?\x00BC) ;; VULGAR FRACTION ONE QUARTER
     (?,H=(B . ?\x00BD) ;; VULGAR FRACTION ONE HALF
     (?,H>(B . ?\x00BE) ;; VULGAR FRACTION THREE QUARTERS
     (?,H_(B . ?\x2017) ;; DOUBLE LOW LINE
     (?,H`(B . ?\x05D0) ;; HEBREW LETTER ALEF
     (?,Ha(B . ?\x05D1) ;; HEBREW LETTER BET
     (?,Hb(B . ?\x05D2) ;; HEBREW LETTER GIMEL
     (?,Hc(B . ?\x05D3) ;; HEBREW LETTER DALET
     (?,Hd(B . ?\x05D4) ;; HEBREW LETTER HE
     (?,He(B . ?\x05D5) ;; HEBREW LETTER VAV
     (?,Hf(B . ?\x05D6) ;; HEBREW LETTER ZAYIN
     (?,Hg(B . ?\x05D7) ;; HEBREW LETTER HET
     (?,Hh(B . ?\x05D8) ;; HEBREW LETTER TET
     (?,Hi(B . ?\x05D9) ;; HEBREW LETTER YOD
     (?,Hj(B . ?\x05DA) ;; HEBREW LETTER FINAL KAF
     (?,Hk(B . ?\x05DB) ;; HEBREW LETTER KAF
     (?,Hl(B . ?\x05DC) ;; HEBREW LETTER LAMED
     (?,Hm(B . ?\x05DD) ;; HEBREW LETTER FINAL MEM
     (?,Hn(B . ?\x05DE) ;; HEBREW LETTER MEM
     (?,Ho(B . ?\x05DF) ;; HEBREW LETTER FINAL NUN
     (?,Hp(B . ?\x05E0) ;; HEBREW LETTER NUN
     (?,Hq(B . ?\x05E1) ;; HEBREW LETTER SAMEKH
     (?,Hr(B . ?\x05E2) ;; HEBREW LETTER AYIN
     (?,Hs(B . ?\x05E3) ;; HEBREW LETTER FINAL PE
     (?,Ht(B . ?\x05E4) ;; HEBREW LETTER PE
     (?,Hu(B . ?\x05E5) ;; HEBREW LETTER FINAL TSADI
     (?,Hv(B . ?\x05E6) ;; HEBREW LETTER TSADI
     (?,Hw(B . ?\x05E7) ;; HEBREW LETTER QOF
     (?,Hx(B . ?\x05E8) ;; HEBREW LETTER RESH
     (?,Hy(B . ?\x05E9) ;; HEBREW LETTER SHIN
     (?,Hz(B . ?\x05EA) ;; HEBREW LETTER TAV
     )))

(provide 'uiso8859-8)
 