/* vi:set ts=8 sts=0 sw=8:
 * $Id: undo.h,v 1.4 2000/02/21 06:52:41 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __UNDO_H__
#define __UNDO_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "main.h"
#if defined(USE_UNDOREDO) && defined(GTK_HAVE_FEATURES_1_1_0)

typedef enum { UndoDelete = 1, UndoInsert, UndoReplace } undo_op_t;

struct undo_s {
	char *text;	/* text to be inserted or deleted */
	int start;	/* starts at this position */
	int end;	/* ends at this position */
	bool_t changed;	/* doc changed status at this undo node */
	undo_op_t op;	/* action to execute */
};
typedef struct undo_s undo_t;

extern void	undo_cb(GtkWidget *wgt, gpointer cbdata);
extern void	redo_cb(GtkWidget *wgt, gpointer cbdata);
extern void	undo_all_cb(GtkWidget *wgt, gpointer cbdata);
extern void	redo_all_cb(GtkWidget *wgt, gpointer cbdata);
extern void	undo_list_add(doc_t *, char *, int, int, undo_op_t op);
extern GList *	undo_list_delete(GList *list);

#else

#define undo_list_add(d, t, s, b, op)
#define undo_list_delete(l)

#endif	/* USE_UNDOREDO */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __UNDO_H__ */
