/* $Id: mdi.c,v 1.2 2000/02/27 07:51:40 kitame Exp $

  GnomeMDI control functions for DEdit

  Copyright (C) 1999  Takuo KITAME

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License with
  the Debian GNU/Linux distribution in file /usr/doc/copyright/GPL;
  if not, write to the Free Software Foundation, Inc., 59 Temple Place,
  Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>

#include <gnome.h>

#include "dedit.h"
#include "mdi.h"

/* MDI Style Menu*/
void
mdi_default_cb(void)
{

#ifdef TRACE_FUNC
    printf("mdi_default_cb()\n");
#endif

    gnome_mdi_set_mode(DEmdi, GNOME_MDI_DEFAULT_MODE);
}

void
mdi_notebook_cb(void)
{

#ifdef TRACE_FUNC
    printf("mdi_notebook_cb()\n");
#endif

    gnome_mdi_set_mode(DEmdi, GNOME_MDI_NOTEBOOK);
}

void
mdi_toplevel_cb(void)
{

#ifdef TRACE_FUNC
    printf("mdi_toplevel_cb()\n");
#endif

    gnome_mdi_set_mode(DEmdi, GNOME_MDI_TOPLEVEL);
}

void
mdi_modal_cb(void)
{

#ifdef TRACE_FUNC
    printf("mdi_modal_cb()\n");
#endif
  
    gnome_mdi_set_mode(DEmdi, GNOME_MDI_MODAL);
}

DEdit *
get_doc_from_mdi_child(void)
{
    DEdit *tmp;
    GnomeMDIChild *active_child;

#ifdef TRACE_FUNC
    printf("get_doc_from_mdi_child()\n");
#endif

    active_child = gnome_mdi_get_active_child(DEmdi);
    if(active_child) {
        tmp = (DEdit *)gtk_object_get_data(GTK_OBJECT(active_child),
                                           "DEditDoc");
		return tmp;
    }

    return NULL;
}
