/* $Id: callbacks.c,v 1.6 2000/02/27 08:46:18 kitame Exp $

  Functions for main

  Copyright (C) 1999  Takuo KITAME

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License with
  the Debian GNU/Linux distribution in file /usr/doc/copyright/GPL;
  if not, write to the Free Software Foundation, Inc., 59 Temple Place,
  Suite 330, Boston, MA  02111-1307  USA
*/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <zlib.h>

#include <gnome.h>

#include <sys/stat.h>
#ifdef MAX
#undef MAX
#endif
#ifdef MIN
#undef MIN
#endif
#include <sys/param.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <iconv.h>

#include "dedit.h"
#include "utils.h"
#include "jcode.h"
#include "file.h"
#include "mdi.h"
#include "callbacks.h"

const gchar *c_name[4] = {
    "UNKNOWN",
    "EUCJP ",
    "JIS    ",
    "SJIS   ",
}; 

gint fs_code;
gint untitled_num;

static GtkWidget *
dedit_child_create_view(GnomeMDIChild *child, gpointer data)
{
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *s_hbox;
    GtkWidget *vscrollbar;
    GtkWidget *text;
    gint flag = 0;
    DEdit* doc;
    gzFile *fp;
    struct stat st;
    gchar *buffer;
    gchar *rbuffer = NULL;
    guint buffer_size;
    /*  gint i = 2; */

#ifdef TRACE_FUNC
    printf("dedit_child_create_view()\n");
#endif

    doc = (DEdit *)gtk_object_get_data(GTK_OBJECT(child), "DEditDoc");

    doc->w_mode = TRUE;
    doc->code = EUCJP;
    doc->fixed = FALSE;

    vbox = gtk_vbox_new(FALSE, 0);
    hbox = gtk_hbox_new(FALSE, 0);

    gtk_container_border_width(GTK_CONTAINER(vbox), 1);
    gtk_container_border_width(GTK_CONTAINER(hbox), 1);

    text = gtk_text_new(NULL, NULL);

    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), text, TRUE, TRUE, 0);

    gtk_widget_set_usize(text, 450, 300);

    vscrollbar = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
    gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);

    if(doc->filename) {
        if(stat(doc->filename, &st) != -1) {
            if(access(doc->filename, W_OK) == -1)
                doc->w_mode = FALSE;
            flag = 1;
        } 
    }
    
    if(flag) {
        buffer_size = isgz(doc->filename);
        if(buffer_size != 0) {
            doc->w_mode = FALSE;
        } else {
            buffer_size = st.st_size;
        }
        
        if((fp = gzopen(doc->filename, "r")) == NULL) {
            return NULL;
        } /* if(fp) */
        
        gtk_text_freeze(GTK_TEXT(text));
        gtk_text_set_point(GTK_TEXT(text), 0);
		gtk_text_forward_delete(GTK_TEXT(text), -1);

        if((buffer = (gchar *)g_malloc(buffer_size + 1)) == NULL ) {
            g_warning(_("DEdit: %s: Couldn't read, too big?.\n"),
                      doc->filename);
            
            gzclose(fp);
            return NULL;
        } /* if((buffer =)) */

        buffer_size = gzread(fp, buffer, buffer_size);    

        if(fs_code == UNKNOWN) {
            doc->code = int_detect_JCode(buffer);
        } else {
            doc->code = fs_code;
        }
        
        if(doc->code == JIS){ /* JIS to EUC */
            rbuffer = kanji_conv(buffer, "EUC-JP", "ISO-2022-JP");
        } else if(doc->code == SJIS){ /* SJIS to EUC */
            rbuffer = kanji_conv(buffer, "EUC-JP", "SJIS");
        } else {
            doc->code = EUCJP;
            rbuffer = strdup(buffer);
        }
        
        gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL, 
                        rbuffer, -1);

        gtk_text_thaw(GTK_TEXT(text));

        g_free(buffer);
        g_free(rbuffer);

        gzclose(fp);
    } /* if(flag) */
  
    doc->modified_id = gtk_signal_connect(GTK_OBJECT(text), "changed", 
                                          GTK_SIGNAL_FUNC(text_changed_cb),
                                          child);
    doc->modified = FALSE;
    doc->text = text;
    doc->mod_bar = gtk_statusbar_new();
    doc->tit_bar = gtk_statusbar_new();
    doc->code_bar = gtk_statusbar_new();

    s_hbox = gtk_hbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(s_hbox), 1);

    gtk_box_pack_start(GTK_BOX(vbox), s_hbox, FALSE, FALSE, 0);

    gtk_box_pack_start(GTK_BOX(s_hbox), doc->mod_bar, FALSE, FALSE, 1);
    gtk_box_pack_start(GTK_BOX(s_hbox), doc->tit_bar, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(s_hbox), doc->code_bar, FALSE, FALSE, 1);

    gtk_statusbar_push(GTK_STATUSBAR(doc->mod_bar), 1, _("Modified"));
    gtk_statusbar_push(GTK_STATUSBAR(doc->code_bar), 1, c_name[doc->code]);

    if(doc->filename) {
        gtk_statusbar_push(GTK_STATUSBAR(doc->tit_bar), 1, doc->filename);
    } else {
        gtk_statusbar_push(GTK_STATUSBAR(doc->tit_bar), 1, doc->pathend);
    }
    gtk_widget_set_sensitive(GTK_WIDGET(doc->mod_bar), FALSE);

    gtk_text_set_editable(GTK_TEXT(text),  doc->w_mode);

    gtk_widget_show(text);
    gtk_widget_show(vscrollbar);
    gtk_widget_show(hbox);

    gtk_widget_show(doc->mod_bar);
    gtk_widget_show(doc->tit_bar);
    gtk_widget_show(doc->code_bar);
    gtk_widget_show(s_hbox);

    gtk_widget_show(vbox);

	return vbox;
}

/****** Currently not worked!! (unused) ******/
void
fixed_cb(GtkWidget * w, gpointer data)
{
    DEdit *tmp;

#ifdef TRACE_FUNC
    printf("fixed_cb()\n");
#endif
  
	tmp = get_doc_from_mdi_child();

    return;
}

gint
dedit_new_document(GtkWidget *widget, gpointer data)
{
    DEdit *doc;
    struct stat st;
    gint i;
    gchar *buf;

#ifdef TRACE_FUNC
    printf("dedit_new_document()\n");
#endif

    doc  = (DEdit *)g_malloc(sizeof(DEdit));

    doc->path = (gchar *)g_malloc(PATH_MAX);
    doc->filename = NULL;

    doc->search_str = NULL;
    doc->search_pos = 0;
    
    if(data){
        buf = g_strdup((gchar *)data);
		doc->filename = (gchar *)g_malloc(PATH_MAX);
        if(!force_realpath(buf, doc->filename, doc->path)){
            g_warning(_("DEdit: %s is invalid file or path name.\n"), buf);
            g_free(buf);
            g_free(doc);
            return FALSE;
        }
        
        g_free(buf);
        
        if(stat(doc->filename, &st) != -1) {
            if(S_ISDIR(st.st_mode)) {
                g_warning(_("DEdit: %s is Directory, cannot open as a file.\n"),
                          doc->filename);
                g_free(doc->filename);
                g_free(doc->path);
                g_free(doc);
                return FALSE;
            }

            if(access(doc->filename, R_OK) == -1) {
                g_warning(_("DEdit: %s: Permission denied\n"), doc->filename);
                g_free(doc->filename);
                g_free(doc->path);
                g_free(doc);
                return FALSE;
            }
        }      

        for(i = strlen(doc->filename);
            (i >= 0) && (doc->filename[i] != '/');
            i--)
            ;
        if(doc->filename[i] == '/')
            doc->pathend = &doc->filename[i+1];
        else
            doc->pathend = doc->filename;

    } else { /* if(data) */
        doc->filename = NULL;
        doc->path = getcwd(doc->path, PATH_MAX);
        doc->pathend = g_strdup_printf("%s[%d]", _("Untitled"), untitled_num++);
    }

    if((doc->child = gnome_mdi_generic_child_new((gchar *)doc->pathend)) != NULL) {
        gtk_object_set_data (GTK_OBJECT (doc->child), "DEditDoc", doc);
        gnome_mdi_generic_child_set_view_creator(doc->child, 
                                                 dedit_child_create_view, doc->filename);
		gnome_mdi_add_child(DEmdi, GNOME_MDI_CHILD(doc->child));
		gnome_mdi_add_view(DEmdi, GNOME_MDI_CHILD(doc->child)); 

        return TRUE;
    }

    return FALSE;
}

void
add_doc_cb(GtkWidget *widget, gpointer data)
{

#ifdef TRACE_FUNC
    printf("add_doc_cb()\n");
#endif
    
    dedit_new_document(NULL, NULL);

    return;
}

void
remove_cb(GtkWidget *widget)
{

#ifdef TRACE_FUNC
    printf("remoce_cb()\n");
#endif

	if(DEmdi->active_view) {
		gnome_mdi_remove_child(DEmdi, 
                               gnome_mdi_get_child_from_view(DEmdi->active_view),
                               FALSE);
    }
    
    return;
}

void
quit_cb(GtkWidget *widget)
{

#ifdef TRACE_FUNC
    printf("quit_cb()\n");
#endif

	if(gnome_mdi_remove_all(DEmdi, FALSE))
		gtk_object_destroy(GTK_OBJECT(DEmdi));
    
    return;
}
 

void
dedit_cut_cb(GtkWidget *widget, gpointer data)
{
    DEdit *tmp;

#ifdef TRACE_FUNC
    printf("dedit_cut_cb()\n");
#endif

    tmp = get_doc_from_mdi_child();
    if(tmp) {
        gtk_editable_cut_clipboard(GTK_EDITABLE(tmp->text));
    }

    return;
}

void
dedit_copy_cb(GtkWidget *widget, gpointer data)
{
    DEdit *tmp;

#ifdef TRACE_FUNC
    printf("dedit_copy_cb()\n");
#endif

    tmp = get_doc_from_mdi_child();
    if(tmp) {
        gtk_editable_copy_clipboard(GTK_EDITABLE(tmp->text));
    }

    return;
}

void
dedit_paste_cb(GtkWidget *widget, gpointer data)
{
    DEdit *tmp;

#ifdef TRACE_FUNC
    printf("dedit_paste_cb()\n");
#endif

    tmp = get_doc_from_mdi_child();
    if(tmp) {
        gtk_editable_paste_clipboard(GTK_EDITABLE(tmp->text));
    }

    return;
}

void
dedit_select_all_cb(GtkWidget *widget, gpointer data)
{
    DEdit *tmp;

#ifdef TRACE_FUNC
    printf("dedit_select_all_cb()\n");
#endif

    tmp = get_doc_from_mdi_child();  
    if(tmp) {
        gtk_editable_select_region (GTK_EDITABLE (tmp->text), 0, -1);
    }

    return;
}

#ifdef USE_DND 
void
app_created_cb(GnomeMDI *mdi, GnomeApp *app)
{
    enum {
        TARGET_PLAIN,
    };
    static GtkTargetEntry drop_types[] = {
        { "text/plain", 0, TARGET_PLAIN }
    };
    
#ifdef TRACE_FUNC
    printf("app_created_cb()\n");
#endif


    gtk_signal_connect(GTK_OBJECT(app->dock), "drag_data_received",
                       GTK_SIGNAL_FUNC(drop_cb), NULL);
  
    gtk_drag_dest_set (app->dock,
                       GTK_DEST_DEFAULT_MOTION |
                       GTK_DEST_DEFAULT_HIGHLIGHT |
                       GTK_DEST_DEFAULT_DROP,
                       drop_types, sizeof(drop_types) / sizeof(drop_types[0]),
                       GDK_ACTION_COPY);
    return;
}

void
drop_cb(GtkWidget *widget,
        GdkDragContext   *context,
        gint              x,
        gint              y,
        GtkSelectionData *selection_data,
        guint             info,
        guint             time) {
    
#ifdef TRACE_FUNC
    printf("drop_cb\n");
#endif
  
    /* dedit_new_document(NULL, selection_data->data); */
    
    g_print(selection_data->data);
    /* gtk_label_set_text(GTK_LABEL(GTK_BUTTON(widget)->child),
                     selection_data->data); 
    */
    /* We could also handle drops of images here by creating
       a pixmap inside the button - the sky is the limit */
    
    return;
}
#endif /* USE_DND */

void
child_changed_cb(GnomeMDI *mdi, GnomeApp *app)
{
    DEdit *tmp;

#ifdef TRACE_FUNC
    printf("child_changed_cb()\n");
#endif

    tmp = get_doc_from_mdi_child();
    if(tmp) {
        gtk_widget_grab_focus(tmp->text);
    }

    return;
}

gint
remove_child_handler(GnomeMDI *mdi, GnomeMDIChild *child)
{
	gchar question[128];
	gint reply;
    DEdit *doc;
    static GtkWidget *dialog = NULL;

#ifdef TRACE_FUNC
    printf("remoce_child_handler()\n");
#endif

    if(dialog != NULL) {
        return FALSE;
    }

    doc = (DEdit *)gtk_object_get_data(GTK_OBJECT(child), "DEditDoc");    

    if(doc->modified) {
        g_snprintf(question, sizeof(question),
                   _("%s has not saved. Do you really close?\n"), 
                   doc->pathend);

        dialog = gnome_message_box_new(question, GNOME_MESSAGE_BOX_QUESTION, 
                                       GNOME_STOCK_BUTTON_OK, 
                                       GNOME_STOCK_BUTTON_CANCEL, NULL);

        gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);

        reply = gnome_dialog_run_and_close((GnomeDialog *)dialog);

        dialog = NULL;
    
        if(reply == 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

	return TRUE;
}

void
cleanup_cb(GnomeMDI *mdi)
{

#ifdef TRACE_FUNC
    printf("cleanup_cb()\n");
#endif

	gtk_main_quit();

    return;
}

void
text_changed_cb(GtkWidget *widget, gpointer data)
{
    DEdit *doc;
    gchar buf[PATH_MAX];

#ifdef TRACE_FUNC
    printf("text_changed_cb()\n");
#endif
  
    doc = (DEdit *)gtk_object_get_data(GTK_OBJECT(data), "DEditDoc");	
  
    gtk_signal_disconnect(GTK_OBJECT(doc->text), (gint)doc->modified_id);		
    doc->modified_id = FALSE;

    doc->modified = TRUE;

    g_snprintf(buf, sizeof(buf), "*%s", doc->pathend);
  
    gnome_mdi_child_set_name(GNOME_MDI_CHILD(doc->child), buf);

    if(doc->filename)
        gtk_statusbar_push(GTK_STATUSBAR(doc->tit_bar), 1, doc->filename);
    else
        gtk_statusbar_push(GTK_STATUSBAR(doc->tit_bar), 1, doc->pathend);

    gtk_widget_set_sensitive(GTK_WIDGET(doc->mod_bar), doc->modified);
  
    return;
}
