MODULE VOStatusLinePrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       BG  := VOBackground,
       F   := VOFrame,
       FG  := VOFrameGroup,
       FSD := VOFrmSelDlg,
       G   := VOGUIObject,
       L   := VOLabel,
       O   := VOObject,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       S   := VOStatusLine;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs      : S.PrefsDesc;
                iFrmSelDlg : FSD.FrmSelDlg;
                oFrmSelDlg : FSD.FrmSelDlg;
                iFrame     : F.Frame;
                oFrame     : F.Frame;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="StatusLine";
    PG.settings.AddItem(d);

    NEW(d.iFrmSelDlg);
    d.iFrmSelDlg.Init;

    NEW(d.oFrmSelDlg);
    d.oFrmSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.prefs:=S.prefs^;

    d.iFrame.SetInternalFrame(d.prefs.iFrame);
    d.oFrame.SetInternalFrame(d.prefs.oFrame);

    d.iFrmSelDlg.SetFrame(d.prefs.iFrame);
    d.oFrmSelDlg.SetFrame(d.prefs.oFrame);
  END Refresh;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    button    : B.Button;
    frame     : FG.FrameGroup;
    label     : L.Label;

  BEGIN
    d.iFrmSelDlg.SetDisplay(d.display);
    d.iFrmSelDlg.Forward(FSD.setMsg,d);

    d.oFrmSelDlg.SetDisplay(d.display);
    d.oFrmSelDlg.Forward(FSD.setMsg,d);

    NEW(frame);
    frame.Init;
    frame.SetTextLabel("Frames");

      NEW(label);
      label.Init;

        button:=PG.CreateFrameButton(d.prefs.iFrame,d.iFrame,d.display,d.iFrmSelDlg,
                                     d.window.keyHandler,"Select inner frame");
      label.AddTextLabel("Inner",button);

      button:=PG.CreateFrameButton(d.prefs.oFrame,d.oFrame,d.display,d.oFrmSelDlg,
                                   d.window.keyHandler,"Select outer frame");
      label.AddTextLabel("Outer",button);
    frame.Add(label);

    RETURN frame;
  END GetObject;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer   : ARRAY 256 OF CHAR;
    pos      : LONGINT;
    top      : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("StatusLine",appName);
    IF top=NIL THEN
      RETURN;
    END;
    top:=top.GetEntry("STATUSLINE");
    IF top=NIL THEN
      RETURN;
    END;

    IF top.GetStringEntry("innerFrame",buffer) THEN
      pos:=F.GetFrameEntry(buffer);
      IF pos>=0 THEN
        S.prefs.iFrame:=pos;
      ELSE
        p.ErrorWrongData("STATUSLINE/innerFrame",buffer);
      END;
    END;

    IF top.GetStringEntry("outerFrame",buffer) THEN
      pos:=F.GetFrameEntry(buffer);
      IF pos>=0 THEN
        S.prefs.oFrame:=pos;
      ELSE
        p.ErrorWrongData("STATUSLINE/outerFrame",buffer);
      END;
    END;

    S.prefs.background:=BG.LoadBackground(top);
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    S.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("STATUSLINE");
      NEW(value);
      value.Init;
      value.SetValue("innerFrame",F.internalFrames[p.prefs.iFrame]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("outerFrame",F.internalFrames[p.prefs.oFrame]);
    block.AddItem(value);

    BG.SaveBackground(block,p.prefs.background);

    p.SaveItems("StatusLine",block);
  END Save;

  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH
      message : FSD.SetMsg DO
        IF message.source=p.iFrmSelDlg THEN
          p.iFrame.SetInternalFrame(message.frame);
          p.prefs.iFrame:=message.frame;
        ELSE
          p.oFrame.SetInternalFrame(message.frame);
          p.prefs.oFrame:=message.frame;
        END;
    ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOStatusLinePrefs.