/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_label_h
#define _vdkb_label_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>
#include <vdkb/vdkb_evlabel.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBTextLabel: public VDKBEvLabel, public VDKBObject
{

 protected:
  VDKBWidgetPopMenu *popmenu;
  VDKBObjectInspector* inspector;
  VDKEntry* caption;
  VDKCombo *align;
  VDKLabelButton* set;
  VDKCheckButton* wrap;
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBTextLabel(char* name,VDKForm* owner,
		  char* label);
  virtual ~VDKBTextLabel() {}
  virtual VDKString&  Name(char* s = NULL) 
    {
      if(s)
	Caption = s;
      return VDKBObject::Name(s);
      
    }
  virtual int Type() { return vdkbclass_label; }
  virtual char* VDKName() { return "VDKLabel"; }
  virtual int isA() { return vdkbclass_label; }
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  void PopMenu() { popmenu->Popup(); }
  // designer
  bool OnSetJustify(VDKObject*);
  bool OnSetCaption(VDKObject*);
  bool OnSetCaptionWrap(VDKObject*);
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  DECLARE_SIGNAL_LIST(VDKBTextLabel);
  DECLARE_EVENT_LIST(VDKBTextLabel);
};
#endif
