/*
 * ===========================
 * VDK Builder
 * Version 1.0.4
 * Decenber 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */
#if HAVE_GNOME
#ifndef _vdkb_gnomeappbar_h
#define _vdkb_gnomeappbar_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>
#include <vdkb/vdkb_evappbar.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBGnomeAppBar: public VDKBEvGnomeAppBar, public VDKBObject
{

 protected:

  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *delwidget;
  VDKBObjectInspector* inspector;
  VDKCheckButton *has_status,*has_progress;
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner,
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);

  VDKBGnomeAppBar(char* name,
		  VDKForm* owner,
		  bool has_progress = true,
		  bool has_status = true);

  virtual ~VDKBGnomeAppBar() {}
  virtual int Type() { return vdkbclass_gnomeappbar; }
  virtual char* VDKName() { return "VDKGnomeAppBar"; }
  virtual int isA() { return vdkbclass_gnomeappbar; }
  void PopMenu() { popmenu->Popup(); }
  // designer
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  bool OnSetStatus(VDKObject*);
  bool OnSetProgress(VDKObject*);
  DECLARE_SIGNAL_LIST(VDKBGnomeAppBar);
  DECLARE_EVENT_LIST(VDKBGnomeAppBar);
};
#endif
#endif
