<copyright> TOO Timer.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright (C) 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Timer.t,v 1.7 1998/01/05 01:16:51 tiggr Exp $</id>
    </copyright>

<doc> Instances of the {Timer} class provide, in conjunction with the
    {RunLoop}, event scheduling functionality.  {Timer} objects can fire
    once or repeatedly.

    Because the trigger time of a {Timer} can change, in case of repeated
    firing, a {Timer} is not a {Date}: a {Timer} represents a moment in
    time like a {Date}, but a {Date} is assumed to be constant.  </doc>
implementation class
Timer: HeapElement

instance (id)
  withInterval double secs
    invocation Invocation invocation
      repeats: boolean repeats_p = NO
pre
  secs > 0.0 || (!repeats_p && !secs)
{
  = [[self alloc]
     initWithFireTime [Date relativeTimeIntervalSinceNow] + secs
     invocation invocation period: repeats_p ? secs : 0.0];
}
end;

implementation instance
Timer
{
  <doc> The next (relative) moment in time we will fire.  </doc>
  public double fire_time;

  <doc> The repetition period.  This is 0.0 for a single-shot timer.  </doc>
  public double period;

  <doc> The invocation to fire when we do.  </doc>
  Invocation invocation;
}

<doc> Designated initializer.  If the time {d} lies in the past, the timer
    will fire as soon as possible.  </doc>
id (self)
  initWithFireTime double d
        invocation Invocation i
	   period: double p = 0.0
pre
  p >= 0.0
{
  (fire_time, invocation, period) = (d, i, p);
}

void
  fire
{
  [invocation fire];
  if (period != 0.0)
    {
      fire_time += period;
      [[RunLoop current] add_timer self];
    }
}

OutputStream (s)
  writeFields OutputStream s
{
  s = [s print (" fire_time=", fire_time)];
}

/********** RunLoop interaction **********/

<doc> Cancel this timer with the current {RunLoop}.  It must be scheduled
    with that {RunLoop}.  </doc>
void
  cancel
pre
  [self scheduled]
{
  [[RunLoop current] remove_timer self];
}

<doc> Schedule this timer with the current {RunLoop}.  The timer may not
    already be scheduled.  </doc>
void
  schedule
pre
  ![self scheduled]
{
  [[RunLoop current] add_timer self];
}

<doc> Return whether this timer is currently scheduled.  </doc>
boolean
  scheduled
{
  = heap_index != 0;
}

/******************** Comparable ********************/

<doc><h4>Comparable</h4></doc>
int
  compare id other
{
  double ft = [other fire_time];

  = fire_time > ft ? 1 : fire_time < ft ? -1 : 0;
}

end;
