<copyright> Receiving objects over the wire.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: PortDecoder.t,v 1.6 1998/01/22 16:39:39 tiggr Exp $</id>
    </copyright>

implementation class
PortDecoder: BinaryDecoder, PortCoder

end;

implementation instance
PortDecoder

id
  initWithConnection ConnectedConnection c
{
  [super (BinaryDecoder) init];
  = [super (PortCoder) initWithConnection c];
}

<doc> Handle proxy tags before super.  </doc>
Any
  decode byte b
{
  while (b == '~')
    {
      int i = [self readInt];
      [connection localProxyRelease i];
      b = [self readByte];
    }

  if (b == '!')
    {
      = [connection localObject [self readInt]];
      [self nextPrimary ')'];
    }
  else if (b == '$')
    {
      = [connection remoteObject [self readInt]];
      [self nextPrimary ')'];
    }
  else
    = [super decode b];
}

protected byte
  readByte
{
  = [port read];
}

protected void
  readBytes int num
	 to pointer address
{
  // Slow.
  // Sun Dec 29 20:41:23 1996, tiggr@tricky.es.ele.tue.nl
  MutableByteArray buf = [MutableByteArray withCapacity num];
  int read = [port readRange (0, num) into buf];

  if (read != num)
    [[SelectorCondition for self class program-condition
      message [[MutableByteString new]
	       print ("read ", read, " instead of ", num)]
      selector cmd] raise];

  pointer from;
  (from, ) = [buf pointerToElements (0, -1)];

  memcpy (address, from, num);
}

end;
