/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1997 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMOld.m,v 1.5 1998/01/05 01:13:37 tiggr Exp $  */

#define OTMOLD_DECLARE_PRIVATE_METHODS
#import "OTMOld.h"
#import "OTMError.h"
#import "global.h"

@implementation OTMOld

+(OTMOld *) with: (OTMExpr *) e
{
  return [[self gcAlloc] initWithExpr: e];
}

-(id) elaborate
{
  error_for (self, @"`old' used outside postcondition");
  return [CO_OTMError sharedError];
}

-(void) gcReference
{
  MARK (expr);

  [super gcReference];
}

-(id) initWithExpr: (OTMExpr *) e
{
  expr = e;

  return [super init];
}

-(id) oldsEliminated
{
  return emit_old_expr (expr);
}

-(id) resolveInContext: (OTMMeta *) meta
{
  expr = [expr resolveInContext: meta];
  return self;
}

-(id) precompile
{
  error_for (self, @"`old' meaningless outside postcondition");
  return [CO_OTMError sharedError];
}

@end
