/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMBreak.m,v 1.13 1998/01/05 01:12:17 tiggr Exp $  */

#define OTMBREAK_DECLARE_PRIVATE_METHODS
#import "OTMBreak.h"
#import "OTMBasic.h"
#import "OTMCompound.h"
#import "global.h"

@implementation OTMBreak

+(OTMBreak *) jumpStatement
{
  return [self jumpStatementWithValue: void_expr];
}

+(OTMBreak *) jumpStatementWithValue: (OTMExpr *) v
{
  return [[self gcAlloc] initWithValue: v];
}

-(void) compile
{
  [value compile];

  [self compileJump];
}

-(void) compileJump
{
  formac (of, @"%@break;", [self nl]);
}

-(OTMExpr *) elaborate
{
  value = [value elaborate];
  [current_compound setBreakValue: value];

  return self;
}

-(void) gcReference
{
  MARK (value);
  MARK (enclosing_loop);

  [super gcReference];
}

-(id) initWithValue: (OTMExpr *) e
{
  [super initWithType: nil];

  value = e;

  return self;
}

-(TLCons *) resolveWithExpected: (TLCons *) expected
		    convertible: (OTMType *) to
			context: (OTMType *) cxt
			indices: (int *) indices
			  index: (int) index
{
  if (!type)
    {
      TLCons *result = [value resolveWithExpected: expected convertible: to
			      context: cxt indices: indices index: index];
      type = [value type];
      if (!type)
	return result;
    }

  return [super resolveWithExpected: expected convertible: to context: cxt
		indices: indices index: index];
}

-(OTMExpr *) result
{
  return [value result];
}

-(OTMExpr *) value
{
  return value;
}

@end
