<copyright> Conditions classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: ConditionClass.t,v 1.11 1998/01/05 01:05:37 tiggr Exp $</id>
    </copyright>

<doc> Instances of the {ConditionClass} define the hierarchy of conditions
    as carried by {Condition} instances.  Conditions classes could be real
    tom classes, but the features provided by said mechanism are too
    baroque for this purpose---only the inheritance is needed.

    The tom condition class hierarchy does not employ multiple
    inheritance.

    TOM conditions are evidently modelled after CL.  </doc>
implementation class
ConditionClass: State

instance (id)
  with instance (id) super_condition
  name ByteString name
{
  = [[self alloc] init super_condition name name];
}

end;

implementation instance
ConditionClass
{
  <doc> Our super condition class.  The super condition class of the top
      {condition} is {nil}.  </doc>
  id super_condition;

  <doc> Our descriptive name.  </doc>
  public ByteString name;
}

protected id
  init id sc
  name ByteString nm
{
  super_condition = sc;
  name = nm;

  = self;
}

<doc> Return YES iff {other} is a super condition class of the receiving
    condition class.  </doc>
boolean
  isConditionSuper id other
{
  = (self == other
     || (!super_condition ? NO : [super_condition isConditionSuper other]));
}

end;
