<copyright> BucketPointerDictElement class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: BucketPDictElement.t,v 1.4 1998/01/20 17:08:09 tiggr Exp $</id>
    </copyright>

implementation class
BucketPointerDictElement: BucketElement

end;

implementation instance
BucketPointerDictElement
{
  <doc> This bucket element's key.  </doc>
  public pointer key;

  <doc> The value in this bucket element.  </doc>
  public Any value;
}

<doc> Designated initializer.  </doc>
id
  initWith (pointer, All) (k, v)
{
  (key, value) = (k, Any (v));
  = self;
}

<doc> Return the value associated with the key {k}, asking the {next}
    element if this element does not match.

    The implementation by {BucketDictElement}, considers its {key} and
    returns its {value}.  </doc>
Any
  member pointer k
{
  = key == k ? value : !next ? nil : [next member k];
}

<doc> Add the {(k, v)} pair to this bucket, if the key is not already
    present.  Return the number by which this bucket's length has
    increased.  </doc>
int
  add (pointer, All) (k, v)
{
  if (k == key)
    value = Any (v);
  else if (!next)
    {
      next = [[isa alloc] initWith (k, v)];
      = 1;
    }
  else
    = [next add (k, v)];
}

<doc> Starting with this bucket element, remove the objects of which the
    {value} is {gc_dead}.  Return the replacement for this element, and
    the number of bucket elements that were removed from this bucket list.
    </doc>
(id, int)
  gc_mark_values
{
  int n;

  if (next != nil)
    (next, n) = [next gc_mark_values];

  if ([value gc_dead_p])
    return (next, n + 1);

  return (self, n);
}

<doc> Rehash the pointer key.  </doc>
int (code)
  rehash
{
  pointer k = key;
<c>
  code = HASH_POINTER (k);
</c>
}

<doc> Rehash the pointer key.  </doc>
int (code)
  rehashq
{
  pointer k = key;
<c>
  code = HASH_POINTER (k);
</c>
}

<doc> Remove the object with the key {k}.  Return the replacement for this
    element, and the number of bucket elements that were removed from this
    bucket list (max 1).  </doc>
(id, int)
  remove pointer k
{
  int n;

  if (key == k)
    return (next, 1);

  if (next != nil)
    (next, n) = [next remove k];

  return (self, n);
}


end;
