/* Support different runtimes by trying to make them look like GNU's.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: support.h,v 1.4 1998/02/23 14:17:02 tiggr Exp $  */

#import "policy.h"
#import "config.h"

#import <stdarg.h>
#import <stdlib.h>
#import "TLString.h"
#import "TLStream.h"
#if HAVE_UNISTD_H
#import <unistd.h>
#endif
#if HAVE_LIBC_H
#import <libc.h>
#endif
#import <fcntl.h>

@class TLMutableString;

extern id CO_TLCons, CO_TLString, CO_TLNumber, CO_TLSymbol, CO_TLVector;
extern id CO_TLMutableString;

#define UNIMPLEMENTED_POINTER_METHOD  \
  ({[self error: "unimplemented method: `%s'", sel_get_name (_cmd)];  \
    (void *) 0;})

#define UNIMPLEMENTED_INT_METHOD  \
  ({[self error: "unimplemented method: `%s'", sel_get_name (_cmd)];  \
    0;})

#if !HAVE_MEMMOVE
#define memmove(t, f, n)  bcopy (f, t, n)
#endif

#if !HAVE_STRDUP
char *strdup (const char *s);
#endif

#if !HAVE_STRERROR
char *strerror (int errno);
#endif

/* Return the run time of this program so far, in seconds.  */
double get_run_time (void);

/* Allocation stuff which still hasn't made it into a standard library.  */
void xfree (void *);
void *xmalloc (unsigned int n);
void *xrealloc (void *p, unsigned int n);
void *xcalloc (unsigned int n, unsigned int m);

id eval (id a);

int memcasecmp (const char *s1, const char *s2, int n);

void print (id object, id <TLOutputStream> stream, int quoted);
void print_list_element (id object, id <TLOutputStream> stream, int quoted);

/* Print the elements of the list C, using print.  */
void print_list_elements (TLCons *c, id <TLOutputStream> stream, int quoted);

/* Intersect, by modifying the second range, both ranges.  */
void range_intersect (int s1, int l1, int *s2, int *l2);

/* Return an objects description.  */
const char *description (id a);

/* Some routines which should not be in this file.  */
TLMutableString *vformac (id stream, id fmt, va_list ap);
TLMutableString *formac (id stream, id fmt, ...);

/* Some low-level routines without user-serviceable parts.  */
TLMutableString *llvformac (id <TLOutputStream> stream,
			    id <TLString> fmt, va_list ap, TLVector *av);

/* Return the number of arguments to the selector SEL, without the return
   value and the implicit SELF and _CMD.  On the GNU runtime, the RCV is
   not actually used.  This is faster, but less accurate.  */
int sel_num_args (id rcv, SEL sel);

/* Return !0 iff, apart from _CMD, all arguments and the return value of
   the selector SEL are objects.  On the GNU runtime, the RCV is not
   actually used.  This is faster, but less accurate.  */
BOOL sel_objects_only (id rcv, SEL sel);

#if GNU_RUNTIME
#import <objc/objc-api.h>
#endif

#if NEXT_RUNTIME

#define CLS_ISCLASS(C)  (CLS_GETINFO ((C), CLS_CLASS))

__TL_INLINE__ long
class_get_instance_size (struct objc_class *class)
{
  return (CLS_ISCLASS (class) ? class->instance_size : 0);
}

__TL_INLINE__ struct objc_class *
objc_get_class (const char *name)
{
  return ((void *) objc_getClass (name));
}

__TL_INLINE__ const char *
sel_get_name (SEL selector)
{
  return (sel_getName (selector));
}

__TL_INLINE__ struct objc_class *
objc_lookup_class (const char *name)
{
  return ((void *) objc_getClass (name));
}

__TL_INLINE__ struct objc_class *
class_pose_as (struct objc_class *imposter, struct objc_class *super)
{
  return (class_poseAs (imposter, super));
}

__TL_INLINE__ const char *
class_get_class_name (struct objc_class *class)
{
  return (CLS_ISCLASS (class) ? class->name : "not a class");
}

__TL_INLINE__ SEL
sel_get_any_uid (const char *name)
{
  return (sel_getUid (name));
}

#endif

#if !HAVE_GETCWD

__TL_INLINE__ char *
getcwd (char *buf, int size)
{
  if (!buf)
    buf = xmalloc (MAXPATHLEN + 1);
  return (getwd (buf));
}

#endif

/* All integers from -1 up to, and including, 9.  */
#define TL_SMALL_INT_MIN  -1
#define TL_SMALL_INT_MAX  9
extern TLNumber **tll_small_int;

#if !HAVE_BOOLEAN
typedef unsigned char boolean;
#endif

boolean fsdo_lock (const char *zlock, boolean fspooldir, boolean *pferr);
boolean fsdo_unlock (const char *zlock, boolean fspooldir);
