/* Interface to TLSet class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLSet.h,v 1.1 1998/01/08 16:13:33 tiggr Exp $  */

#import "TLObject.h"
#import "TLEnumerator.h"

@interface TLSet: TLObject
{
  /* The number of buckets.  */
  unsigned int nbucket;

  /* The number of objects.  */
  unsigned int nobject;

  /* The buckets.  */
  struct element **buckets;
}

/******************** creation ********************/

/* Return a new empty set.  */
+(TLSet *) set;

/* Return a new set with the element from the enumerator.  */
+(TLSet *) setWithEnumerator: (id <TLEnumerator>) en;

/* Return a new set solely containing the object O.  */
+(TLSet *) setWithElement: (id) o;

/* Return a new set with the elements from the sequence SEQ.  */
+(TLSet *) setWithSequence: seq;

/******************** comparison ********************/

/* Return non-nil if O is a set containing exactly the same objects.  */
-equal: (id) o;

/******************** enumeration ********************/

-(id <TLEnumerator>) enumerator;

/******************** retrieving information ********************/

/* Return the number of elements.  */
-(int) length;
-objectLength;

/* Is ELT part of the set?  Comparison with `eq'.  Return NIL if it is not
   found, ELT otherwise.  */
-memq: (id) elt;

/* Is ELT part of the set?  Comparison with `equal'.  Return NIL if it is
   not found, the element from the set otherwise.  */
-member: (id) elt;

/******************** modification ********************/

-(id) addElement: (id) e;

/* Remove the element which is equal to E.  */
-(id) removeElement: (id) e;

/* Remove the element which is eq E.  */
-(id) removeElementIdenticalTo: (id) e;

/* Return a new set being the union of the receiving and argument sets.  */
-(TLSet *) setByUnionWithSequence: (id) seq;
-(TLSet *) setByUnionWithEnumerator: (id <TLEnumerator>) e;

/* Return a new set being the intersection of the receiving and argument
   sets.  */
-(TLSet *) setByIntersectionWithSequence: (id) seq;
-(TLSet *) setByIntersectionWithEnumerator: (id <TLEnumerator>) e;

/* Modify the receiving set by adding to it the elements from the argument
   sequence or enumerator, respectively.  */
-(TLSet *) unionWithSequence: (id) seq;
-(TLSet *) unionWithEnumerator: (id <TLEnumerator>) e;

#ifdef TLSET_DECLARE_PRIVATE_METHODS

-(struct element *) _elementAtIndex: (int *) bucket : (int *) depth;

/* Resize the set, by doubling + 1 its capacity.  This is expensive, since
   all objects basically are re-inserted.  */
-(void) reconfigure;

#endif

@end
